/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.migration.command;

import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.command.CommandArguments;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.config.Perms;
import su.nightexpress.coinsengine.currency.CurrencyRegistry;
import su.nightexpress.coinsengine.migration.MigrationManager;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.Commands;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.ExecutableNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;

public class MigrationCommands {
    private final CoinsEnginePlugin plugin;
    private final MigrationManager migrationManager;
    private final CurrencyRegistry currencyRegistry;

    public MigrationCommands(@NotNull CoinsEnginePlugin plugin, @NotNull MigrationManager migrationManager, @NotNull CurrencyRegistry currencyRegistry) {
        this.plugin = plugin;
        this.migrationManager = migrationManager;
        this.currencyRegistry = currencyRegistry;
    }

    public void load() {
        this.plugin.getCommander().getPluginCommands().registerProvider(builder -> builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"migrate").permission((Permission)Perms.COMMAND_MIGRATE)).description(Lang.COMMAND_MIGRATE_DESC)).withArguments(new ArgumentNodeBuilder[]{Arguments.string((String)"name").localized(Lang.COMMAND_ARGUMENT_NAME_PLUGIN).suggestions((reader, context) -> this.migrationManager.getMigratorNames()), CommandArguments.currency(this.currencyRegistry)}).executes(this::migrate)}));
    }

    private boolean migrate(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        String name = arguments.getString("name");
        Currency currency = (Currency)arguments.get("currency", Currency.class);
        return this.migrationManager.startMigration(context.getSender(), name, currency);
    }
}

