/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.hook.impl;

import net.zithium.deluxecoinflip.api.DeluxeCoinflipAPI;
import net.zithium.deluxecoinflip.economy.provider.EconomyProvider;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.currency.CurrencyManager;
import su.nightexpress.coinsengine.currency.operation.NotificationTarget;
import su.nightexpress.coinsengine.currency.operation.OperationContext;
import su.nightexpress.coinsengine.data.impl.CoinsUser;

public class DeluxeCoinflipHook {
    public static void setup(@NotNull CoinsEnginePlugin plugin) {
        DeluxeCoinflipAPI api = (DeluxeCoinflipAPI)plugin.getPluginManager().getPlugin("DeluxeCoinflip");
        if (api == null) {
            return;
        }
        plugin.getCurrencyRegistry().getCurrencies().forEach(currency -> {
            Provider provider = new Provider(plugin, (Currency)currency);
            api.registerEconomyProvider((EconomyProvider)provider, plugin.getName());
        });
    }

    public static void shutdown() {
    }

    private static class Provider
    extends EconomyProvider {
        private final CoinsEnginePlugin plugin;
        private final CurrencyManager manager;
        private final Currency currency;

        public Provider(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency) {
            super("coinsengine_" + currency.getId());
            this.plugin = plugin;
            this.manager = plugin.getCurrencyManager();
            this.currency = currency;
        }

        public void onEnable() {
        }

        public String getDisplayName() {
            return this.currency.getName();
        }

        @Nullable
        private CoinsUser getUser(@NotNull OfflinePlayer offlinePlayer) {
            return (CoinsUser)this.plugin.getUserManager().getOrFetch(offlinePlayer.getUniqueId());
        }

        public double getBalance(OfflinePlayer offlinePlayer) {
            CoinsUser user = this.getUser(offlinePlayer);
            return user == null ? 0.0 : user.getBalance(this.currency);
        }

        public void withdraw(OfflinePlayer offlinePlayer, double amount) {
            this.plugin.getUserManager().manageUser(offlinePlayer.getUniqueId(), user -> {
                if (user == null) {
                    return;
                }
                this.manager.remove(this.operationContext(), (CoinsUser)((Object)user), this.currency, amount);
            });
        }

        public void deposit(OfflinePlayer offlinePlayer, double amount) {
            this.plugin.getUserManager().manageUser(offlinePlayer.getUniqueId(), user -> {
                if (user == null) {
                    return;
                }
                this.manager.give(this.operationContext(), (CoinsUser)((Object)user), this.currency, amount);
            });
        }

        @NotNull
        private OperationContext operationContext() {
            return OperationContext.custom("DeluxeCoinflip").silentFor(NotificationTarget.USER, NotificationTarget.EXECUTOR, NotificationTarget.CONSOLE_LOGGER);
        }
    }
}

