/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.data.DataQueries;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.coinsengine.data.impl.CurrencySettings;
import su.nightexpress.coinsengine.data.serialize.CurrencySettingsSerializer;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.db.AbstractUserDataManager;
import su.nightexpress.nightcore.db.sql.column.Column;
import su.nightexpress.nightcore.db.sql.column.ColumnType;
import su.nightexpress.nightcore.db.sql.query.impl.SelectQuery;
import su.nightexpress.nightcore.db.sql.query.impl.UpdateQuery;
import su.nightexpress.nightcore.db.sql.query.type.ValuedQuery;
import su.nightexpress.nightcore.util.Lists;

public class DataHandler
extends AbstractUserDataManager<CoinsEnginePlugin, CoinsUser> {
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(CurrencySettings.class, (Object)new CurrencySettingsSerializer()).create();
    static final Column COLUMN_SETTINGS = Column.of((String)"settings", (ColumnType)ColumnType.STRING);
    static final Column COLUMN_HIDE_FROM_TOPS = Column.of((String)"hiddenFromTops", (ColumnType)ColumnType.BOOLEAN);
    static final Map<String, Column> CURRENCY_COLUMNS = new HashMap<String, Column>();
    private boolean synchronizationActive;

    public DataHandler(@NotNull CoinsEnginePlugin plugin) {
        super((NightPlugin)plugin);
        this.setSynchronizationActive(true);
    }

    public void setSynchronizationActive(boolean synchronizationActive) {
        this.synchronizationActive = synchronizationActive;
    }

    @NotNull
    public String getUsersTable() {
        return this.tableUsers;
    }

    protected void onClose() {
        super.onClose();
        CURRENCY_COLUMNS.clear();
    }

    @NotNull
    protected Function<ResultSet, CoinsUser> createUserFunction() {
        return DataQueries.USER_LOADER;
    }

    @NotNull
    protected GsonBuilder registerAdapters(@NotNull GsonBuilder builder) {
        return builder;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.dropColumn(this.tableUsers, new String[]{"balances", "currencyData"});
        this.addColumn(this.tableUsers, COLUMN_SETTINGS, "{}");
        this.addColumn(this.tableUsers, COLUMN_HIDE_FROM_TOPS, String.valueOf(0));
    }

    @NotNull
    public static Column getCurrencyColumn(@NotNull Currency currency) {
        return DataHandler.getCurrencyColumn(currency.getId());
    }

    @NotNull
    public static Column getCurrencyColumn(@NotNull String currencyId) {
        return CURRENCY_COLUMNS.get(currencyId);
    }

    public static boolean isCurrencyColumnCached(@NotNull Currency currency) {
        return CURRENCY_COLUMNS.containsKey(currency.getId());
    }

    public void onCurrencyRegister(@NotNull Currency currency) {
        this.addCurrencyColumn(currency);
    }

    public void onCurrencyUnload(@NotNull Currency currency) {
        CURRENCY_COLUMNS.remove(currency.getId());
    }

    public void addCurrencyColumn(@NotNull Currency currency) {
        Column column = Column.of((String)currency.getColumnName(), (ColumnType)ColumnType.DOUBLE);
        this.addColumn(this.tableUsers, column, String.valueOf(currency.getStartValue()));
        CURRENCY_COLUMNS.put(currency.getId(), column);
    }

    protected void addUpsertQueryData(@NotNull ValuedQuery<?, CoinsUser> query) {
        query.setValue(COLUMN_SETTINGS, user -> GSON.toJson(user.getSettingsMap()));
        query.setValue(COLUMN_HIDE_FROM_TOPS, user -> String.valueOf(user.isHiddenFromTops() ? 1 : 0));
        CURRENCY_COLUMNS.forEach((id, column) -> query.setValue(column, user -> String.valueOf(user.getBalance().get((String)id))));
    }

    protected void addSelectQueryData(@NotNull SelectQuery<CoinsUser> query) {
        query.column(COLUMN_SETTINGS);
        query.column(COLUMN_HIDE_FROM_TOPS);
        CURRENCY_COLUMNS.values().forEach(arg_0 -> query.column(arg_0));
    }

    protected void addTableColumns(@NotNull List<Column> columns) {
        columns.add(COLUMN_SETTINGS);
        columns.add(COLUMN_HIDE_FROM_TOPS);
    }

    public void onSynchronize() {
        if (!this.synchronizationActive) {
            return;
        }
        this.synchronizer.syncAll();
    }

    public void resetBalances(@NotNull Currency currency) {
        this.resetBalances(Lists.newSet((Object[])new Currency[]{currency}));
    }

    public void resetBalances(@NotNull Collection<Currency> currencies) {
        UpdateQuery query = new UpdateQuery();
        for (Currency currency : currencies) {
            query.setValue(DataHandler.getCurrencyColumn(currency), o -> String.valueOf(currency.getStartValue()));
        }
        this.update(this.tableUsers, query, new Object());
    }
}

