/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.currency.operation;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.currency.operation.NotificationTarget;
import su.nightexpress.coinsengine.currency.operation.OperationExecutor;

public class OperationContext {
    private final OperationExecutor executor;
    private final EnumSet<NotificationTarget> notificationTargets;

    private OperationContext(@NotNull OperationExecutor executor) {
        this.executor = executor;
        this.notificationTargets = EnumSet.allOf(NotificationTarget.class);
    }

    @NotNull
    public static OperationContext of(@NotNull OperationExecutor sender) {
        return new OperationContext(sender);
    }

    @NotNull
    public static OperationContext of(@NotNull CommandSender sender) {
        return OperationContext.of(OperationExecutor.of(sender));
    }

    @NotNull
    public static OperationContext custom(@NotNull String name) {
        return OperationContext.of(OperationExecutor.custom(name));
    }

    @NotNull
    public static OperationContext console() {
        return OperationContext.of((CommandSender)Bukkit.getConsoleSender());
    }

    @NotNull
    public static OperationContext consoleQuiet() {
        return OperationContext.console().silent();
    }

    @NotNull
    public OperationContext silent() {
        return this.silentFor(NotificationTarget.values());
    }

    @NotNull
    public OperationContext silentFor(NotificationTarget ... targets) {
        Arrays.asList(targets).forEach(this.notificationTargets::remove);
        return this;
    }

    @NotNull
    public OperationContext silentFor(@NotNull NotificationTarget target, boolean flag) {
        if (flag) {
            this.notificationTargets.remove((Object)target);
        } else {
            this.notificationTargets.add(target);
        }
        return this;
    }

    public boolean shouldNotify(@NotNull NotificationTarget target) {
        return this.notificationTargets.contains((Object)target);
    }

    public boolean shouldNotifyLogger() {
        return this.shouldNotify(NotificationTarget.CONSOLE_LOGGER) || this.shouldNotify(NotificationTarget.FILE_LOGGER);
    }

    @NotNull
    public OperationExecutor getExecutor() {
        return this.executor;
    }

    @NotNull
    public Optional<CommandSender> getBukkitSender() {
        return this.executor.getBukkitSender();
    }
}

