/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.currency;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.config.Config;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.currency.CurrencyFactory;
import su.nightexpress.coinsengine.currency.CurrencyLogger;
import su.nightexpress.coinsengine.currency.CurrencyRegistry;
import su.nightexpress.coinsengine.currency.impl.AbstractCurrency;
import su.nightexpress.coinsengine.currency.impl.NormalCurrency;
import su.nightexpress.coinsengine.currency.operation.NotificationTarget;
import su.nightexpress.coinsengine.currency.operation.OperationContext;
import su.nightexpress.coinsengine.currency.operation.OperationExecutor;
import su.nightexpress.coinsengine.currency.operation.OperationResult;
import su.nightexpress.coinsengine.data.DataHandler;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.coinsengine.data.impl.CurrencySettings;
import su.nightexpress.coinsengine.user.UserManager;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.db.AbstractUser;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.Strings;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.placeholder.Replacer;

public class CurrencyManager
extends AbstractManager<CoinsEnginePlugin> {
    private final CurrencyRegistry registry;
    private final DataHandler dataHandler;
    private final UserManager userManager;
    private boolean operationsAllowed;
    private CurrencyLogger logger;

    public CurrencyManager(@NotNull CoinsEnginePlugin plugin, @NotNull CurrencyRegistry registry, @NotNull DataHandler dataHandler, @NotNull UserManager userManager) {
        super((NightCorePlugin)plugin);
        this.registry = registry;
        this.dataHandler = dataHandler;
        this.userManager = userManager;
        this.allowOperations();
    }

    protected void onLoad() {
        this.createDefaults();
        this.migrateSettings();
        FileUtil.findYamlFiles((String)this.getDirectory()).forEach(this::loadCurrency);
        try {
            this.loadLogger();
        }
        catch (IOException | IllegalArgumentException exception) {
            ((CoinsEnginePlugin)this.plugin).error("Could not create operations logger: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    protected void onShutdown() {
        this.registry.getCurrencies().forEach(this::unregisterCurrency);
        if (this.logger != null) {
            this.logger.shutdown();
        }
        this.disableOperations();
    }

    private void migrateSettings() {
        FileUtil.findYamlFiles((String)this.getDirectory()).forEach(path -> {
            String fileName = path.getFileName().toString();
            if (!fileName.endsWith(".yml")) {
                return;
            }
            FileConfig config = FileConfig.load((Path)path);
            if (!config.contains("Economy")) {
                return;
            }
            if (config.getBoolean("Economy.Vault")) {
                String name = fileName.substring(0, fileName.length() - ".yml".length());
                Config.INTEGRATION_VAULT_ECONOMY_CURRENCY.set((Object)name);
                Config.INTEGRATION_VAULT_ECONOMY_CURRENCY.write(((CoinsEnginePlugin)this.plugin).getConfig());
            }
            config.remove("Economy");
            config.saveChanges();
        });
    }

    private void loadCurrency(@NotNull Path path) throws IllegalStateException {
        String fileName = path.getFileName().toString();
        if (!fileName.endsWith(".yml")) {
            return;
        }
        String name = fileName.substring(0, fileName.length() - ".yml".length());
        String id = (String)Strings.varStyle((String)name).orElseThrow(() -> new IllegalStateException("Malformed file name '" + fileName + "'"));
        boolean isVault = Plugins.isInstalled((String)"Vault") && (Boolean)Config.INTEGRATION_VAULT_ENABLED.get() != false;
        boolean isGoodId = ((String)Config.INTEGRATION_VAULT_ECONOMY_CURRENCY.get()).equalsIgnoreCase(id);
        AbstractCurrency currency = isVault && isGoodId ? CurrencyFactory.createEconomy(path, id, (CoinsEnginePlugin)this.plugin, this, this.dataHandler, this.userManager) : CurrencyFactory.createNormal(path, id);
        if (currency.isPrimary() && this.registry.hasPrimary()) {
            ((CoinsEnginePlugin)this.plugin).warn("Could not load primary currency '" + currency.getId() + "' as there is already one present. Reboot the server if you want to change your primary currency.");
            return;
        }
        currency.load();
        this.registerCurrency(currency);
    }

    private void createDefaults() {
        File dir = new File(this.getDirectory());
        if (dir.exists()) {
            return;
        }
        this.createCurrency("coins", currency -> {
            currency.setSymbol("\u26c2");
            currency.setIcon(NightItem.fromType((Material)Material.SUNFLOWER));
            currency.setDecimal(false);
        });
        this.createCurrency("money", currency -> {
            currency.setSymbol("$");
            currency.setFormat("%currency_symbol%%amount%");
            currency.setFormat(currency.getFormat());
            currency.setIcon(NightItem.fromType((Material)Material.GOLD_NUGGET));
            currency.setDecimal(true);
        });
    }

    private void loadLogger() throws IOException, IllegalArgumentException {
        boolean logToConsole = (Boolean)Config.LOGS_TO_CONSOLE.get();
        boolean logToFile = (Boolean)Config.LOGS_TO_FILE.get();
        if (!logToConsole && !logToFile) {
            return;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern((String)Config.LOGS_DATE_FORMAT.get());
        Path filePath = Paths.get(((CoinsEnginePlugin)this.plugin).getDataFolder().getAbsolutePath(), "operations.log");
        this.logger = new CurrencyLogger((CoinsEnginePlugin)this.plugin, formatter, filePath, logToConsole, logToFile);
        this.addAsyncTask(() -> this.logger.write(), (Integer)Config.LOGS_WRITE_INTERVAL.get());
    }

    @NotNull
    public String getDirectory() {
        return String.valueOf(((CoinsEnginePlugin)this.plugin).getDataFolder()) + "/currencies/";
    }

    public void registerCurrency(@NotNull Currency currency) {
        if (this.registry.isRegistered(currency.getId())) {
            ((CoinsEnginePlugin)this.plugin).error("Could not register duplicated currency: '" + currency.getId() + "'!");
            return;
        }
        if (DataHandler.isCurrencyColumnCached(currency)) {
            ((CoinsEnginePlugin)this.plugin).error("Currency '" + currency.getId() + "' tried to use column '" + currency.getColumnName() + "' which is already used by other currency!");
            return;
        }
        this.registry.add(currency);
        this.dataHandler.onCurrencyRegister(currency);
        ((CoinsEnginePlugin)this.plugin).info("Currency registered: '" + currency.getId() + "'.");
    }

    public boolean unregisterCurrency(@NotNull Currency currency) {
        return this.unregisterCurrency(currency.getId());
    }

    public boolean unregisterCurrency(@NotNull String id) {
        Currency currency = this.registry.remove(id);
        if (currency == null) {
            return false;
        }
        this.dataHandler.onCurrencyUnload(currency);
        ((CoinsEnginePlugin)this.plugin).info("Currency unregistered: '" + currency.getId() + "'.");
        return true;
    }

    @Deprecated
    @NotNull
    public Collection<Currency> getCurrencies() {
        return this.registry.getCurrencies();
    }

    public void allowOperations() {
        this.operationsAllowed = true;
        this.dataHandler.setSynchronizationActive(true);
    }

    public void disableOperations() {
        this.operationsAllowed = false;
        this.dataHandler.setSynchronizationActive(false);
    }

    public boolean canPerformOperations() {
        return this.operationsAllowed;
    }

    private boolean assertOperationsEnabled(@NotNull OperationContext context) {
        if (!this.canPerformOperations()) {
            context.getBukkitSender().ifPresent(sender -> Lang.CURRENCY_OPERATION_DISABLED.message().send(sender));
            return false;
        }
        return true;
    }

    @NotNull
    public NormalCurrency createCurrency(@NotNull String id, @NotNull Consumer<NormalCurrency> consumer) {
        Path path = Paths.get(this.getDirectory(), FileConfig.withExtension((String)id));
        NormalCurrency currency = new NormalCurrency(path, id);
        consumer.accept(currency);
        currency.write();
        return currency;
    }

    public boolean createCurrency(@NotNull CommandSender sender, @NotNull String name, @NotNull String symbol, boolean decimals) {
        String id = Strings.varStyle((String)name).orElse(null);
        if (id == null) {
            Lang.CURRENCY_CREATE_BAD_NAME.message().send(sender);
            return false;
        }
        if (this.registry.isRegistered(id)) {
            Lang.CURRENCY_CREATE_DUPLICATED.message().send(sender);
            return false;
        }
        NormalCurrency created = this.createCurrency(id, currency -> {
            currency.setSymbol(symbol);
            currency.setDecimal(decimals);
        });
        created.updateMessagePrefix();
        this.registerCurrency(created);
        ((CoinsEnginePlugin)this.plugin).getCommander().getCurrencyCommands().loadCommands(created);
        Lang.CURRENCY_CREATE_SUCCESS.message().send(sender, replacer -> replacer.replace(created.replacePlaceholders()));
        return true;
    }

    public void resetBalances(@NotNull CommandSender sender) {
        this.resetBalances(sender, null);
    }

    public void resetBalances(@NotNull CommandSender sender, @Nullable Currency currency) {
        if (!this.canPerformOperations()) {
            Lang.RESET_ALL_START_BLOCKED.message().send(sender);
            return;
        }
        ((CoinsEnginePlugin)this.plugin).runTaskAsync(task -> {
            this.disableOperations();
            if (currency == null) {
                Collection<Currency> currencies = this.registry.getCurrencies();
                Lang.RESET_ALL_STARTED_GLOBAL.message().send(sender);
                this.dataHandler.resetBalances(currencies);
                this.userManager.getLoaded().forEach(user -> user.resetBalance(currencies));
                Lang.RESET_ALL_COMPLETED_GLOBAL.message().send(sender);
            } else {
                Lang.RESET_ALL_STARTED_CURRENCY.message().send(sender, replacer -> replacer.replace(currency.replacePlaceholders()));
                this.dataHandler.resetBalances(currency);
                this.userManager.getLoaded().forEach(user -> user.resetBalance(currency));
                Lang.RESET_ALL_COMPLETED_CURRENCY.message().send(sender, replacer -> replacer.replace(currency.replacePlaceholders()));
            }
            this.allowOperations();
        });
    }

    public void showBalance(@NotNull CommandSender sender, @NotNull Currency currency) {
        this.showBalance(sender, sender.getName(), currency);
    }

    public void showBalance(@NotNull CommandSender sender, @NotNull String name, @NotNull Currency currency) {
        boolean isOwn = sender.getName().equalsIgnoreCase(name);
        this.userManager.manageUser(name, user -> {
            if (user == null) {
                CoreLang.ERROR_INVALID_PLAYER.withPrefix((NightPlugin)this.plugin).send(sender);
                return;
            }
            currency.sendPrefixed(isOwn ? Lang.CURRENCY_BALANCE_DISPLAY_OWN : Lang.CURRENCY_BALANCE_DISPLAY_OTHERS, sender, replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace("%balance%", (Object)currency.format(user.getBalance(currency))));
        });
    }

    public void showWallet(@NotNull Player player) {
        this.showWallet((CommandSender)player, player.getName());
    }

    public void showWallet(@NotNull CommandSender sender, @NotNull String name) {
        boolean isOwn = sender.getName().equalsIgnoreCase(name);
        this.userManager.manageUser(name, user -> {
            if (user == null) {
                CoreLang.ERROR_INVALID_PLAYER.withPrefix((NightPlugin)this.plugin).send(sender);
                return;
            }
            (isOwn ? Lang.CURRENCY_WALLET_OWN : Lang.CURRENCY_WALLET_OTHERS).message().send(sender, replacer -> replacer.replace("%entry%", list -> this.registry.getCurrencies().stream().sorted(Comparator.comparing(Currency::getId)).forEach(currency -> {
                Player player;
                if (sender instanceof Player && !currency.hasPermission(player = (Player)sender)) {
                    return;
                }
                list.add(Replacer.create().replace(currency.replacePlaceholders()).replace("%balance%", (Object)currency.format(user.getBalance((Currency)currency))).apply(Lang.CURRENCY_WALLET_ENTRY.text()));
            })).replace("%player_name%", (Object)user.getName()));
        });
    }

    public void togglePayments(@NotNull Player player, @NotNull Currency currency) {
        this.togglePayments((CommandSender)player, player.getName(), currency, false);
    }

    public void togglePayments(@NotNull CommandSender sender, @NotNull String name, @NotNull Currency currency, boolean silent) {
        boolean isOwn = sender.getName().equalsIgnoreCase(name);
        this.userManager.manageUser(name, user -> {
            CurrencySettings settings;
            if (user == null) {
                CoreLang.ERROR_INVALID_PLAYER.withPrefix((NightPlugin)this.plugin).send(sender);
                return;
            }
            settings.setPaymentsEnabled(!(settings = user.getSettings(currency)).isPaymentsEnabled());
            this.userManager.save((AbstractUser)user);
            if (!isOwn) {
                currency.sendPrefixed(Lang.COMMAND_CURRENCY_PAYMENTS_TARGET, sender, replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace("%state%", (Object)CoreLang.STATE_ENABLED_DISALBED.get(settings.isPaymentsEnabled())));
            }
            Player target = user.getPlayer();
            if (!silent && target != null) {
                currency.sendPrefixed(Lang.COMMAND_CURRENCY_PAYMENTS_TOGGLE, (CommandSender)target, replacer -> replacer.replace("%state%", (Object)CoreLang.STATE_ENABLED_DISALBED.get(settings.isPaymentsEnabled())));
            }
        });
    }

    @NotNull
    public OperationResult give(@NotNull OperationContext context, @NotNull Player player, @NotNull Currency currency, double amount) {
        return this.give(context, (CoinsUser)this.userManager.getOrFetch(player), currency, amount);
    }

    @NotNull
    public OperationResult give(@NotNull OperationContext context, @NotNull CoinsUser user, @NotNull Currency currency, double amount) {
        Player target;
        if (!this.assertOperationsEnabled(context)) {
            return OperationResult.FAILURE;
        }
        OperationExecutor executor = context.getExecutor();
        user.addBalance(currency, amount);
        this.userManager.save(user);
        if (this.logger != null && context.shouldNotifyLogger()) {
            this.logger.addEntry(context, "[%s] %s gave %s to %s. New balance: %s".formatted(currency.getId(), executor.getName(), currency.format(amount), user.getName(), currency.format(user.getBalance(currency))));
        }
        if (context.shouldNotify(NotificationTarget.EXECUTOR)) {
            executor.getBukkitSender().ifPresent(sender -> currency.sendPrefixed(Lang.COMMAND_CURRENCY_GIVE_DONE, (CommandSender)sender, replacer -> replacer.replace("%player_name%", () -> ((CoinsUser)user).getName()).replace("%amount%", () -> currency.format(amount)).replace("%balance%", () -> currency.format(user.getBalance(currency)))));
        }
        if (context.shouldNotify(NotificationTarget.USER) && (target = user.getPlayer()) != null) {
            currency.sendPrefixed(Lang.COMMAND_CURRENCY_GIVE_NOTIFY, (CommandSender)target, replacer -> replacer.replace("%amount%", () -> currency.format(amount)).replace("%balance%", () -> currency.format(user.getBalance(currency))));
        }
        return OperationResult.SUCCESS;
    }

    @NotNull
    public OperationResult giveAll(@NotNull OperationContext context, @NotNull Currency currency, double amount) {
        if (!this.assertOperationsEnabled(context)) {
            return OperationResult.FAILURE;
        }
        OperationExecutor executor = context.getExecutor();
        Set users = this.userManager.getLoaded();
        users.forEach(user -> {
            Player target = user.getPlayer();
            if (target == null) {
                return;
            }
            user.addBalance(currency, amount);
            this.userManager.save((AbstractUser)user);
            if (context.shouldNotify(NotificationTarget.USER)) {
                currency.sendPrefixed(Lang.COMMAND_CURRENCY_GIVE_NOTIFY, (CommandSender)target, replacer -> replacer.replace("%amount%", () -> currency.format(amount)).replace("%balance%", () -> currency.format(user.getBalance(currency))));
            }
        });
        if (this.logger != null && context.shouldNotifyLogger()) {
            this.logger.addEntry(context, "[%s] %s gave %s to all online players. Affected players (%s): %s".formatted(currency.getId(), executor.getName(), currency.format(amount), users.size(), users.stream().map(AbstractUser::getName).collect(Collectors.joining(", "))));
        }
        if (context.shouldNotify(NotificationTarget.EXECUTOR)) {
            executor.getBukkitSender().ifPresent(sender -> currency.sendPrefixed(Lang.COMMAND_CURRENCY_GIVE_ALL_DONE, (CommandSender)sender, replacer -> replacer.replace("%amount%", (Object)currency.format(amount))));
        }
        return OperationResult.SUCCESS;
    }

    @NotNull
    public OperationResult remove(@NotNull OperationContext context, @NotNull Player player, @NotNull Currency currency, double amount) {
        return this.remove(context, (CoinsUser)this.userManager.getOrFetch(player), currency, amount);
    }

    @NotNull
    public OperationResult remove(@NotNull OperationContext context, @NotNull CoinsUser user, @NotNull Currency currency, double amount) {
        if (!this.assertOperationsEnabled(context)) {
            return OperationResult.FAILURE;
        }
        OperationExecutor executor = context.getExecutor();
        user.removeBalance(currency, amount);
        this.userManager.save(user);
        if (this.logger != null && context.shouldNotifyLogger()) {
            this.logger.addEntry(context, "[%s] %s took %s from %s's balance. New balance: %s".formatted(currency.getId(), executor.getName(), currency.format(amount), user.getName(), currency.format(user.getBalance(currency))));
        }
        if (context.shouldNotify(NotificationTarget.EXECUTOR)) {
            executor.getBukkitSender().ifPresent(sender -> currency.sendPrefixed(Lang.COMMAND_CURRENCY_TAKE_DONE, (CommandSender)sender, replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)currency.format(user.getBalance(currency)))));
        }
        if (context.shouldNotify(NotificationTarget.USER)) {
            Optional.ofNullable(user.getPlayer()).ifPresent(target -> currency.sendPrefixed(Lang.COMMAND_CURRENCY_TAKE_NOTIFY, (CommandSender)target, replacer -> replacer.replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)currency.format(user.getBalance(currency)))));
        }
        return OperationResult.SUCCESS;
    }

    @NotNull
    public OperationResult set(@NotNull OperationContext context, @NotNull Player player, @NotNull Currency currency, double amount) {
        return this.set(context, (CoinsUser)this.userManager.getOrFetch(player), currency, amount);
    }

    @NotNull
    public OperationResult set(@NotNull OperationContext context, @NotNull CoinsUser user, @NotNull Currency currency, double amount) {
        if (!this.assertOperationsEnabled(context)) {
            return OperationResult.FAILURE;
        }
        OperationExecutor executor = context.getExecutor();
        user.setBalance(currency, amount);
        this.userManager.save(user);
        if (this.logger != null && context.shouldNotifyLogger()) {
            this.logger.addEntry(context, "[%s] %s set %s's balance to %s. New balance: %s".formatted(currency.getId(), executor.getName(), user.getName(), currency.format(amount), currency.format(user.getBalance(currency))));
        }
        if (context.shouldNotify(NotificationTarget.EXECUTOR)) {
            executor.getBukkitSender().ifPresent(sender -> currency.sendPrefixed(Lang.COMMAND_CURRENCY_SET_DONE, (CommandSender)sender, replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)currency.format(user.getBalance(currency)))));
        }
        if (context.shouldNotify(NotificationTarget.USER)) {
            Optional.ofNullable(user.getPlayer()).ifPresent(target -> currency.sendPrefixed(Lang.COMMAND_CURRENCY_SET_NOTIFY, (CommandSender)target, replacer -> replacer.replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)currency.format(user.getBalance(currency)))));
        }
        return OperationResult.SUCCESS;
    }

    @NotNull
    public OperationResult reset(@NotNull OperationContext context, @NotNull Player player, @NotNull Currency currency) {
        return this.reset(context, (CoinsUser)this.userManager.getOrFetch(player), currency);
    }

    @NotNull
    public OperationResult reset(@NotNull OperationContext context, @NotNull CoinsUser user, @NotNull Currency currency) {
        if (!this.assertOperationsEnabled(context)) {
            return OperationResult.FAILURE;
        }
        OperationExecutor executor = context.getExecutor();
        user.resetBalance(currency);
        this.userManager.save(user);
        if (this.logger != null && context.shouldNotifyLogger()) {
            this.logger.addEntry(context, "[%s] %s reset %s's balance of %s to %s.".formatted(currency.getId(), executor.getName(), user.getName(), currency.getName(), currency.format(user.getBalance(currency))));
        }
        if (context.shouldNotify(NotificationTarget.EXECUTOR)) {
            executor.getBukkitSender().ifPresent(sender -> currency.sendPrefixed(Lang.CURRENCY_OPERATION_RESET_FEEDBACK, (CommandSender)sender, replacer -> replacer.replace("%player_name%", (Object)user.getName()).replace("%balance%", (Object)currency.format(user.getBalance(currency)))));
        }
        if (context.shouldNotify(NotificationTarget.USER)) {
            Optional.ofNullable(user.getPlayer()).ifPresent(target -> currency.sendPrefixed(Lang.CURRENCY_OPERATION_RESET_NOTIFY, (CommandSender)target, replacer -> replacer.replace("%balance%", (Object)currency.format(user.getBalance(currency)))));
        }
        return OperationResult.SUCCESS;
    }

    public boolean send(@NotNull Player sender, @NotNull String targetName, @NotNull Currency currency, double rawAmount) {
        OperationContext context = OperationContext.of((CommandSender)sender);
        if (!this.assertOperationsEnabled(context)) {
            return false;
        }
        double amount = currency.floorIfNeeded(rawAmount);
        if (amount <= 0.0) {
            return false;
        }
        if (sender.getName().equalsIgnoreCase(targetName)) {
            CoreLang.COMMAND_EXECUTION_NOT_YOURSELF.withPrefix((NightPlugin)this.plugin).send((CommandSender)sender);
            return false;
        }
        double minAmount = currency.getMinTransferAmount();
        if (minAmount > 0.0 && amount < minAmount) {
            currency.sendPrefixed(Lang.CURRENCY_SEND_ERROR_TOO_LOW, (CommandSender)sender, replacer -> replacer.replace("%amount%", (Object)currency.format(minAmount)));
            return false;
        }
        CoinsUser fromUser = (CoinsUser)this.userManager.getOrFetch(sender);
        if (amount > fromUser.getBalance(currency)) {
            currency.sendPrefixed(Lang.CURRENCY_SEND_ERROR_NOT_ENOUGH, (CommandSender)sender);
            return false;
        }
        this.userManager.manageUser(targetName, targetUser -> {
            if (targetUser == null) {
                CoreLang.ERROR_INVALID_PLAYER.withPrefix((NightPlugin)this.plugin).send((CommandSender)sender);
                return;
            }
            CurrencySettings settings = targetUser.getSettings(currency);
            if (!settings.isPaymentsEnabled()) {
                currency.sendPrefixed(Lang.CURRENCY_SEND_ERROR_NO_PAYMENTS, (CommandSender)sender, replacer -> replacer.replace("%player_name%", (Object)targetUser.getName()));
                return;
            }
            targetUser.addBalance(currency, amount);
            fromUser.removeBalance(currency, amount);
            this.userManager.save((AbstractUser)targetUser);
            this.userManager.save(fromUser);
            currency.sendPrefixed(Lang.CURRENCY_SEND_DONE_SENDER, (CommandSender)sender, replacer -> replacer.replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)fromUser.getBalance(currency)).replace("%player_name%", (Object)targetUser.getName()));
            Optional.ofNullable(targetUser.getPlayer()).ifPresent(target -> currency.sendPrefixed(Lang.CURRENCY_SEND_DONE_NOTIFY, (CommandSender)target, replacer -> replacer.replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)targetUser.getBalance(currency)).replace("%player_name%", (Object)sender.getName())));
            this.logger.addEntry(context, "[%s] %s paid %s to %s. New balances: %s and %s.".formatted(currency.getId(), sender.getName(), currency.format(amount), targetUser.getName(), currency.format(fromUser.getBalance(currency)), currency.format(targetUser.getBalance(currency))));
        });
        return true;
    }

    public boolean exchange(@NotNull Player player, @NotNull Currency sourceCurrency, @NotNull Currency targetCurrency, double initAmount) {
        OperationContext context = OperationContext.of((CommandSender)player);
        if (!this.assertOperationsEnabled(context)) {
            return false;
        }
        if (!sourceCurrency.isExchangeAllowed()) {
            sourceCurrency.sendPrefixed(Lang.CURRENCY_EXCHANGE_ERROR_DISABLED, (CommandSender)player);
            return false;
        }
        double amount = sourceCurrency.floorIfNeeded(initAmount);
        if (amount <= 0.0) {
            sourceCurrency.sendPrefixed(Lang.CURRENCY_EXCHANGE_ERROR_LOW_AMOUNT, (CommandSender)player);
            return false;
        }
        CoinsUser user = (CoinsUser)this.userManager.getOrFetch(player);
        if (user.getBalance(sourceCurrency) < amount) {
            sourceCurrency.sendPrefixed(Lang.CURRENCY_EXCHANGE_ERROR_LOW_BALANCE, (CommandSender)player, replacer -> replacer.replace("%amount%", (Object)sourceCurrency.format(amount)));
            return false;
        }
        if (!sourceCurrency.canExchangeTo(targetCurrency)) {
            sourceCurrency.sendPrefixed(Lang.CURRENCY_EXCHANGE_ERROR_NO_RATE, (CommandSender)player, replacer -> replacer.replace("%name%", (Object)targetCurrency.getName()));
            return false;
        }
        double result = sourceCurrency.getExchangeResult(targetCurrency, amount);
        if (result <= 0.0) {
            sourceCurrency.sendPrefixed(Lang.CURRENCY_EXCHANGE_ERROR_LOW_AMOUNT, (CommandSender)player);
            return false;
        }
        double newBalance = user.getBalance(targetCurrency) + result;
        if (!targetCurrency.isUnderLimit(newBalance)) {
            targetCurrency.sendPrefixed(Lang.CURRENCY_EXCHANGE_ERROR_LIMIT_EXCEED, (CommandSender)player, replacer -> replacer.replace("%amount%", (Object)targetCurrency.format(result)).replace("%max%", (Object)targetCurrency.format(targetCurrency.getMaxValue())));
            return false;
        }
        user.removeBalance(sourceCurrency, amount);
        user.addBalance(targetCurrency, result);
        this.userManager.save(user);
        sourceCurrency.sendPrefixed(Lang.CURRENCY_EXCHANGE_SUCCESS, (CommandSender)player, replacer -> replacer.replace("%balance%", (Object)sourceCurrency.format(amount)).replace("%amount%", (Object)targetCurrency.format(result)));
        this.logger.addEntry(context, "[%s] %s exchanged %s for %s [%s]. New balances: %s and %s.".formatted(sourceCurrency.getId(), user.getName(), sourceCurrency.format(amount), targetCurrency.format(result), targetCurrency.getId(), sourceCurrency.format(user.getBalance(sourceCurrency)), targetCurrency.format(user.getBalance(targetCurrency))));
        return true;
    }
}

