/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.command.plugin;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.command.CommandArguments;
import su.nightexpress.coinsengine.command.plugin.CommandProvider;
import su.nightexpress.coinsengine.config.Config;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.config.Perms;
import su.nightexpress.coinsengine.currency.CurrencyManager;
import su.nightexpress.coinsengine.currency.CurrencyRegistry;
import su.nightexpress.coinsengine.currency.operation.NotificationTarget;
import su.nightexpress.coinsengine.currency.operation.OperationContext;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.Commands;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.ExecutableNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.command.NightCommand;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.manager.SimpleManager;
import su.nightexpress.nightcore.util.Lists;

public class PluginCommands
extends SimpleManager<CoinsEnginePlugin> {
    private final CurrencyRegistry currencyRegistry;
    private final CurrencyManager currencyManager;
    private final Set<CommandProvider> providers;
    private final Set<NightCommand> commands;

    public PluginCommands(@NotNull CoinsEnginePlugin plugin, @NotNull CurrencyRegistry currencyRegistry, @NotNull CurrencyManager currencyManager) {
        super((NightCorePlugin)plugin);
        this.currencyRegistry = currencyRegistry;
        this.currencyManager = currencyManager;
        this.providers = new HashSet<CommandProvider>();
        this.commands = new HashSet<NightCommand>();
    }

    protected void onLoad() {
        this.loadAdminCommands();
        this.loadGlobalCommands();
    }

    protected void onShutdown() {
        this.commands.forEach(NightCommand::unregister);
        this.commands.clear();
    }

    public void registerProvider(@NotNull CommandProvider provider) {
        this.providers.add(provider);
    }

    private void loadAdminCommands() {
        this.registerCommand((NightCommand)NightCommand.forPlugin((NightPlugin)((NightPlugin)this.plugin), builder -> {
            builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"reload").description(CoreLang.COMMAND_RELOAD_DESC)).permission((Permission)Perms.COMMAND_RELOAD)).executes((context, arguments) -> {
                ((CoinsEnginePlugin)this.plugin).doReload(context.getSender());
                return true;
            })});
            builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"create").permission((Permission)Perms.COMMAND_CREATE)).description(Lang.COMMAND_CREATE_DESC)).withArguments(new ArgumentNodeBuilder[]{Arguments.string((String)"name").localized(CoreLang.COMMAND_ARGUMENT_NAME_NAME), Arguments.string((String)"symbol").localized(Lang.COMMAND_ARGUMENT_NAME_SYMBOL), Arguments.bool((String)"decimals").localized(Lang.COMMAND_ARGUMENT_NAME_DECIMAL).optional().suggestions((reader, context) -> Lists.newList((Object[])new String[]{"true", "false"}))}).executes(this::createCurrency)});
            builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"reset").permission((Permission)Perms.COMMAND_RESET)).description(Lang.COMMAND_RESET_DESC)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), CommandArguments.currency(this.currencyRegistry)}).withFlags(new String[]{"s", "sf"}).executes(this::reset)});
            builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"resetall").permission((Permission)Perms.COMMAND_RESET_ALL)).description(Lang.COMMAND_RESET_ALL_DESC)).withArguments(new ArgumentNodeBuilder[]{CommandArguments.currency(this.currencyRegistry).optional()}).executes(this::resetAll)});
            this.providers.forEach(provider -> provider.build((HubNodeBuilder)builder));
        }));
    }

    private void loadGlobalCommands() {
        if (Config.isWalletEnabled()) {
            this.registerCommand((NightCommand)NightCommand.literal((NightPlugin)((NightPlugin)this.plugin), (String[])((String[])Config.WALLET_ALIASES.get()), builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(Lang.COMMAND_WALLET_DESC)).permission((Permission)Perms.COMMAND_WALLET)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission((Permission)Perms.COMMAND_WALLET_OTHERS)).optional()}).executes(this::showWallet)));
        }
    }

    private void registerCommand(@NotNull NightCommand command) {
        if (command.register()) {
            this.commands.add(command);
        }
    }

    private boolean createCurrency(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        String name = arguments.getString("name");
        String symbol = arguments.getString("symbol");
        boolean decimals = arguments.getBoolean("decimals", true);
        return this.currencyManager.createCurrency(context.getSender(), name, symbol, decimals);
    }

    private boolean showWallet(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        String name = arguments.getString("player", context.getSender().getName());
        this.currencyManager.showWallet(context.getSender(), name);
        return true;
    }

    private boolean reset(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Currency currency = (Currency)arguments.get("currency", Currency.class);
        ((CoinsEnginePlugin)this.plugin).getUserManager().manageUser(arguments.getString("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            OperationContext operationContext = OperationContext.of(context.getSender()).silentFor(NotificationTarget.USER, context.hasFlag("s")).silentFor(NotificationTarget.EXECUTOR, context.hasFlag("sf"));
            this.currencyManager.reset(operationContext, (CoinsUser)((Object)user), currency);
        });
        return true;
    }

    private boolean resetAll(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        if (arguments.contains("currency")) {
            Currency currency = (Currency)arguments.get("currency", Currency.class);
            this.currencyManager.resetBalances(context.getSender(), currency);
        } else {
            this.currencyManager.resetBalances(context.getSender());
        }
        return true;
    }
}

