/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.command.currency.provider.impl;

import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.command.CommandArguments;
import su.nightexpress.coinsengine.command.currency.CommandDefinition;
import su.nightexpress.coinsengine.command.currency.CommandVariant;
import su.nightexpress.coinsengine.command.currency.provider.type.CurrencyCommandProvider;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.config.Perms;
import su.nightexpress.coinsengine.currency.CurrencyManager;
import su.nightexpress.coinsengine.currency.CurrencyRegistry;
import su.nightexpress.coinsengine.currency.operation.NotificationTarget;
import su.nightexpress.coinsengine.currency.operation.OperationContext;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;

public class GiveProvider
extends CurrencyCommandProvider {
    public GiveProvider(@NotNull CoinsEnginePlugin plugin, @NotNull CurrencyRegistry registry, @NotNull CurrencyManager manager) {
        super(plugin, registry, manager, "add");
    }

    @Override
    public void buildRoot(@NotNull Currency currency, @NotNull HubNodeBuilder builder) {
    }

    @Override
    public void build(@NotNull Currency currency, @NotNull LiteralNodeBuilder builder) {
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.permission((Permission)Perms.COMMAND_CURRENCY_GIVE)).description(Lang.COMMAND_CURRENCY_GIVE_DESC)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), CommandArguments.amount()}).withFlags(new String[]{"s", "sf"}).executes((context, arguments) -> {
            double amount = arguments.getDouble("amount");
            if (amount <= 0.0) {
                return false;
            }
            String playerName = arguments.getString("player");
            this.plugin.getUserManager().manageUser(playerName, user -> {
                if (user == null) {
                    context.errorBadPlayer();
                    return;
                }
                OperationContext operationContext = OperationContext.of(context.getSender()).silentFor(NotificationTarget.CONSOLE_LOGGER).silentFor(NotificationTarget.USER, context.hasFlag("s")).silentFor(NotificationTarget.EXECUTOR, context.hasFlag("sf"));
                this.manager.give(operationContext, (CoinsUser)((Object)((Object)user)), currency, amount);
            });
            return true;
        });
    }

    @Override
    public boolean isAvailable(@NotNull Currency currency) {
        return true;
    }

    @Override
    @NotNull
    public CommandDefinition getDefaultDefinition() {
        return new CommandDefinition(CommandVariant.enabled("give"), CommandVariant.disabled("addmoney"));
    }
}

