/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.command.currency;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.command.currency.CommandDefinition;
import su.nightexpress.coinsengine.command.currency.CommandVariant;
import su.nightexpress.coinsengine.command.currency.provider.CommandProvider;
import su.nightexpress.coinsengine.command.currency.provider.impl.BalanceProvider;
import su.nightexpress.coinsengine.command.currency.provider.impl.ExchangeProvider;
import su.nightexpress.coinsengine.command.currency.provider.impl.GiveAllProvider;
import su.nightexpress.coinsengine.command.currency.provider.impl.GiveProvider;
import su.nightexpress.coinsengine.command.currency.provider.impl.PaymentsProvider;
import su.nightexpress.coinsengine.command.currency.provider.impl.RemoveProvider;
import su.nightexpress.coinsengine.command.currency.provider.impl.SendProvider;
import su.nightexpress.coinsengine.command.currency.provider.impl.SetProvider;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.currency.CurrencyManager;
import su.nightexpress.coinsengine.currency.CurrencyRegistry;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.commands.Commands;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.command.HubCommand;
import su.nightexpress.nightcore.commands.command.LiteralCommand;
import su.nightexpress.nightcore.commands.command.NightCommand;
import su.nightexpress.nightcore.commands.tree.ExecutableNode;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.SimpleManager;
import su.nightexpress.nightcore.util.LowerCase;

public class CurrencyCommands
extends SimpleManager<CoinsEnginePlugin> {
    private final CurrencyRegistry currencyRegistry;
    private final CurrencyManager currencyManager;
    private final Map<String, CommandProvider> providerByNameMap;
    private final Map<String, CommandDefinition> definitionByNameMap;
    private final Map<String, Set<NightCommand>> currencyCommands;

    public CurrencyCommands(@NotNull CoinsEnginePlugin plugin, @NotNull CurrencyRegistry currencyRegistry, @NotNull CurrencyManager currencyManager) {
        super((NightCorePlugin)plugin);
        this.currencyRegistry = currencyRegistry;
        this.currencyManager = currencyManager;
        this.providerByNameMap = new HashMap<String, CommandProvider>();
        this.definitionByNameMap = new HashMap<String, CommandDefinition>();
        this.currencyCommands = new HashMap<String, Set<NightCommand>>();
        this.registerDefaultProviders();
    }

    protected void onLoad() {
        this.loadCommands();
    }

    protected void onShutdown() {
        this.currencyRegistry.getCurrencies().forEach(this::unregisterCommands);
        this.currencyCommands.values().forEach(set -> set.forEach(NightCommand::unregister));
        this.currencyCommands.clear();
        this.definitionByNameMap.clear();
        this.providerByNameMap.clear();
    }

    private void registerDefaultProviders() {
        this.registerProvider(new BalanceProvider((CoinsEnginePlugin)this.plugin, this.currencyRegistry, this.currencyManager));
        this.registerProvider(new SendProvider((CoinsEnginePlugin)this.plugin, this.currencyRegistry, this.currencyManager));
        this.registerProvider(new PaymentsProvider((CoinsEnginePlugin)this.plugin, this.currencyRegistry, this.currencyManager));
        this.registerProvider(new GiveProvider((CoinsEnginePlugin)this.plugin, this.currencyRegistry, this.currencyManager));
        this.registerProvider(new GiveAllProvider((CoinsEnginePlugin)this.plugin, this.currencyRegistry, this.currencyManager));
        this.registerProvider(new SetProvider((CoinsEnginePlugin)this.plugin, this.currencyRegistry, this.currencyManager));
        this.registerProvider(new RemoveProvider((CoinsEnginePlugin)this.plugin, this.currencyRegistry, this.currencyManager));
        this.registerProvider(new ExchangeProvider((CoinsEnginePlugin)this.plugin, this.currencyRegistry, this.currencyManager));
    }

    public void registerProvider(@NotNull CommandProvider provider) {
        this.providerByNameMap.put(provider.getName(), provider);
    }

    private void loadCommands() {
        this.loadCommandDefinitions();
        this.currencyRegistry.getCurrencies().forEach(this::loadCommands);
    }

    private void loadCommandDefinitions() {
        String path;
        FileConfig config = FileConfig.load((String)((CoinsEnginePlugin)this.plugin).getDataFolder().getPath(), (String)"commands.yml");
        if (config.getSection(path = "Commands.").isEmpty()) {
            this.providerByNameMap.forEach((name, provider) -> config.set(path + "." + name, (Object)provider.getDefaultDefinition()));
        }
        config.getSection(path).forEach(sId -> {
            String name = LowerCase.INTERNAL.apply(sId);
            if (!this.providerByNameMap.containsKey(name)) {
                ((CoinsEnginePlugin)this.plugin).warn("Unknown command '" + sId + "' in '" + String.valueOf(config.getPath()) + "'.");
                return;
            }
            CommandDefinition definition = CommandDefinition.read(config, path + "." + sId);
            this.definitionByNameMap.put(name, definition);
        });
        config.saveChanges();
    }

    public void loadCommands(@NotNull Currency currency) {
        HubCommand currencyCommand = NightCommand.hub((NightPlugin)((NightPlugin)this.plugin), (String[])currency.getCommandAliases(), rootBuilder -> {
            rootBuilder.permission(currency.isPermissionRequired() ? currency.getPermission() : null);
            rootBuilder.description((String)currency.replacePlaceholders().apply(Lang.COMMAND_CURRENCY_ROOT_DESC.text()));
            this.providerByNameMap.forEach((name, provider) -> {
                CommandDefinition balanceDef = this.definitionByNameMap.getOrDefault(name, provider.getDefaultDefinition());
                CommandVariant children = balanceDef.children();
                CommandVariant dedicated = balanceDef.dedicated();
                if (!children.enabled() && !dedicated.enabled()) {
                    return;
                }
                if (!provider.isAvailable(currency)) {
                    return;
                }
                provider.buildRoot(currency, (HubNodeBuilder)rootBuilder);
                if (children.enabled()) {
                    rootBuilder.branch(new ExecutableNode[]{Commands.literal((String)children.aliases()[0], builder -> provider.build(currency, (LiteralNodeBuilder)builder))});
                }
                if (dedicated.enabled() && currency.isPrimary()) {
                    LiteralCommand command = NightCommand.literal((NightPlugin)((NightPlugin)this.plugin), (String[])dedicated.aliases(), builder -> provider.build(currency, (LiteralNodeBuilder)builder));
                    this.registerCommand(currency, (NightCommand)command);
                }
            });
        });
        this.registerCommand(currency, (NightCommand)currencyCommand);
    }

    private void registerCommand(@NotNull Currency currency, @NotNull NightCommand command) {
        if (command.register()) {
            this.currencyCommands.computeIfAbsent(currency.getId(), k -> new HashSet()).add(command);
        }
    }

    public void unregisterCommands(@NotNull Currency currency) {
        Set<NightCommand> commands = this.currencyCommands.remove(currency.getId());
        if (commands == null) {
            return;
        }
        commands.forEach(NightCommand::unregister);
    }
}

