/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.api;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.command.CommandManager;
import su.nightexpress.coinsengine.currency.CurrencyManager;
import su.nightexpress.coinsengine.currency.CurrencyRegistry;
import su.nightexpress.coinsengine.currency.operation.NotificationTarget;
import su.nightexpress.coinsengine.currency.operation.OperationContext;
import su.nightexpress.coinsengine.currency.operation.OperationResult;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.coinsengine.user.UserManager;

public class CoinsEngineAPI {
    private static CoinsEnginePlugin plugin;

    public static void load(@NotNull CoinsEnginePlugin plugin) {
        CoinsEngineAPI.plugin = plugin;
    }

    public static void clear() {
        plugin = null;
    }

    public static boolean isLoaded() {
        return plugin != null;
    }

    @NotNull
    public static CoinsEnginePlugin plugin() {
        if (plugin == null) {
            throw new IllegalStateException("API is not yet initialized!");
        }
        return plugin;
    }

    @NotNull
    public static UserManager getUserManager() {
        return CoinsEngineAPI.plugin().getUserManager();
    }

    @NotNull
    public static CurrencyManager getCurrencyManager() {
        return CoinsEngineAPI.plugin().getCurrencyManager();
    }

    @NotNull
    public static CurrencyRegistry getCurrencyRegistry() {
        return CoinsEngineAPI.plugin().getCurrencyRegistry();
    }

    @NotNull
    public static CommandManager getCommandManager() {
        return CoinsEngineAPI.plugin().getCommander();
    }

    @NotNull
    public static Collection<Currency> getCurrencies() {
        return CoinsEngineAPI.getCurrencyRegistry().getCurrencies();
    }

    @Nullable
    public static Currency getCurrency(@NotNull String id) {
        return CoinsEngineAPI.getCurrencyRegistry().getById(id);
    }

    public static boolean hasCurrency(@NotNull String id) {
        return CoinsEngineAPI.getCurrencyRegistry().isRegistered(id);
    }

    public static void regsiterCurrency(@NotNull Currency currency) {
        CoinsEngineAPI.getCurrencyManager().registerCurrency(currency);
    }

    public static void regsiterCurrencyWithCommands(@NotNull Currency currency) {
        CoinsEngineAPI.regsiterCurrency(currency);
        CoinsEngineAPI.getCommandManager().getCurrencyCommands().loadCommands(currency);
    }

    public static void unregsiterCurrency(@NotNull Currency currency) {
        CoinsEngineAPI.getCommandManager().getCurrencyCommands().unregisterCommands(currency);
        CoinsEngineAPI.getCurrencyManager().unregisterCurrency(currency);
    }

    public static double getBalance(@NotNull UUID playerId, @NotNull String currencyName) {
        Currency currency = CoinsEngineAPI.getCurrency(currencyName);
        return currency == null ? 0.0 : CoinsEngineAPI.getBalance(playerId, currency);
    }

    public static double getBalance(@NotNull UUID playerId, @NotNull Currency currency) {
        CoinsUser user = CoinsEngineAPI.getUserData(playerId);
        return user == null ? 0.0 : user.getBalance(currency);
    }

    public static double getBalance(@NotNull Player player, @NotNull Currency currency) {
        return CoinsEngineAPI.getUserData(player).getBalance(currency);
    }

    public static boolean addBalance(@NotNull UUID playerId, @NotNull String currencyName, double amount) {
        Currency currency = CoinsEngineAPI.getCurrency(currencyName);
        return currency != null && CoinsEngineAPI.addBalance(playerId, currency, amount);
    }

    public static boolean addBalance(@NotNull UUID playerId, @NotNull Currency currency, double amount) {
        return CoinsEngineAPI.addBalance(playerId, currency, amount, CoinsEngineAPI.operationContext());
    }

    public static boolean addBalance(@NotNull UUID playerId, @NotNull Currency currency, double amount, @NotNull OperationContext context) {
        return CoinsEngineAPI.editBalance(playerId, user -> CoinsEngineAPI.getCurrencyManager().give(context, (CoinsUser)((Object)user), currency, amount));
    }

    public static void addBalance(@NotNull Player player, @NotNull Currency currency, double amount) {
        CoinsEngineAPI.addBalance(player, currency, amount, CoinsEngineAPI.operationContext());
    }

    public static boolean addBalance(@NotNull Player player, @NotNull Currency currency, double amount, @NotNull OperationContext context) {
        return CoinsEngineAPI.getCurrencyManager().give(context, player, currency, amount) == OperationResult.SUCCESS;
    }

    public static boolean removeBalance(@NotNull UUID playerId, @NotNull String currencyName, double amount) {
        Currency currency = CoinsEngineAPI.getCurrency(currencyName);
        return currency != null && CoinsEngineAPI.removeBalance(playerId, currency, amount);
    }

    public static boolean removeBalance(@NotNull UUID playerId, @NotNull Currency currency, double amount) {
        return CoinsEngineAPI.removeBalance(playerId, currency, amount, CoinsEngineAPI.operationContext());
    }

    public static void removeBalance(@NotNull Player player, @NotNull Currency currency, double amount) {
        CoinsEngineAPI.removeBalance(player, currency, amount, CoinsEngineAPI.operationContext());
    }

    public static boolean removeBalance(@NotNull UUID playerId, @NotNull Currency currency, double amount, @NotNull OperationContext context) {
        return CoinsEngineAPI.editBalance(playerId, user -> CoinsEngineAPI.getCurrencyManager().remove(context, (CoinsUser)((Object)user), currency, amount));
    }

    public static boolean removeBalance(@NotNull Player player, @NotNull Currency currency, double amount, @NotNull OperationContext context) {
        return CoinsEngineAPI.getCurrencyManager().remove(context, player, currency, amount) == OperationResult.SUCCESS;
    }

    public static boolean setBalance(@NotNull UUID playerId, @NotNull String currencyName, double amount) {
        Currency currency = CoinsEngineAPI.getCurrency(currencyName);
        return currency != null && CoinsEngineAPI.setBalance(playerId, currency, amount);
    }

    public static boolean setBalance(@NotNull UUID playerId, @NotNull Currency currency, double amount) {
        return CoinsEngineAPI.setBalance(playerId, currency, amount, CoinsEngineAPI.operationContext());
    }

    public static void setBalance(@NotNull Player player, @NotNull Currency currency, double amount) {
        CoinsEngineAPI.setBalance(player, currency, amount, CoinsEngineAPI.operationContext());
    }

    public static boolean setBalance(@NotNull UUID playerId, @NotNull Currency currency, double amount, @NotNull OperationContext context) {
        return CoinsEngineAPI.editBalance(playerId, user -> CoinsEngineAPI.getCurrencyManager().set(context, (CoinsUser)((Object)user), currency, amount));
    }

    public static boolean setBalance(@NotNull Player player, @NotNull Currency currency, double amount, @NotNull OperationContext context) {
        return CoinsEngineAPI.getCurrencyManager().set(context, player, currency, amount) == OperationResult.SUCCESS;
    }

    private static boolean editBalance(@NotNull UUID id, @NotNull Function<CoinsUser, OperationResult> function) {
        CoinsUser user = CoinsEngineAPI.getUserData(id);
        if (user == null) {
            return false;
        }
        OperationResult result = function.apply(user);
        return result == OperationResult.SUCCESS;
    }

    @NotNull
    private static OperationContext operationContext() {
        return OperationContext.custom("API").silentFor(NotificationTarget.USER, NotificationTarget.EXECUTOR, NotificationTarget.CONSOLE_LOGGER);
    }

    @NotNull
    public static CoinsUser getUserData(@NotNull Player player) {
        return (CoinsUser)CoinsEngineAPI.getUserManager().getOrFetch(player);
    }

    @Nullable
    public static CoinsUser getUserData(@NotNull String name) {
        return (CoinsUser)CoinsEngineAPI.getUserManager().getOrFetch(name);
    }

    @Nullable
    public static CoinsUser getUserData(@NotNull UUID uuid) {
        return (CoinsUser)CoinsEngineAPI.getUserManager().getOrFetch(uuid);
    }

    @NotNull
    public static CompletableFuture<CoinsUser> getUserDataAsync(@NotNull String name) {
        return CoinsEngineAPI.getUserManager().getUserDataAsync(name);
    }

    @NotNull
    public static CompletableFuture<CoinsUser> getUserDataAsync(@NotNull UUID uuid) {
        return CoinsEngineAPI.getUserManager().getUserDataAsync(uuid);
    }
}

