/*
 * Decompiled with CFR 0.152.
 */
package newamazingpvp.nohitdelay;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public final class SchedulerAdapter {
    private static final boolean FOLIA_AVAILABLE;
    private static final AtomicBoolean WARNED_FOLIA_FAILURE;

    private SchedulerAdapter() {
    }

    public static boolean isFolia() {
        return FOLIA_AVAILABLE;
    }

    public static void runEntityLater(Plugin plugin, Entity entity, long delayTicks, Runnable task) {
        Objects.requireNonNull(plugin, "plugin");
        Objects.requireNonNull(entity, "entity");
        Objects.requireNonNull(task, "task");
        long delay = Math.max(0L, delayTicks);
        if (!FOLIA_AVAILABLE) {
            Bukkit.getScheduler().runTaskLater(plugin, task, delay);
            return;
        }
        if (delay <= 0L) {
            SchedulerAdapter.deliverToEntity(plugin, entity, task);
            return;
        }
        if (SchedulerAdapter.tryEntityDelayed(plugin, entity, delay, task)) {
            return;
        }
        if (SchedulerAdapter.scheduleDelayThenPostToEntity(plugin, entity, delay, task)) {
            return;
        }
        SchedulerAdapter.deliverToEntity(plugin, entity, task);
    }

    private static boolean tryEntityDelayed(Plugin plugin, Entity entity, long delay, Runnable task) {
        try {
            Object scheduler = SchedulerAdapter.getEntityScheduler(entity);
            Method runDelayedConsumerRetired = SchedulerAdapter.findMethod(scheduler.getClass(), "runDelayed", new Class[]{Plugin.class, Consumer.class, Runnable.class, Long.TYPE});
            if (runDelayedConsumerRetired != null) {
                Consumer<Object> consumer = ignored -> task.run();
                runDelayedConsumerRetired.invoke(scheduler, plugin, consumer, null, delay);
                return true;
            }
            Method runDelayedConsumer = SchedulerAdapter.findMethod(scheduler.getClass(), "runDelayed", new Class[]{Plugin.class, Consumer.class, Long.TYPE});
            if (runDelayedConsumer != null) {
                Consumer<Object> consumer = ignored -> task.run();
                runDelayedConsumer.invoke(scheduler, plugin, consumer, delay);
                return true;
            }
            Method runDelayedRunnableRetired = SchedulerAdapter.findMethod(scheduler.getClass(), "runDelayed", new Class[]{Plugin.class, Runnable.class, Runnable.class, Long.TYPE});
            if (runDelayedRunnableRetired != null) {
                runDelayedRunnableRetired.invoke(scheduler, plugin, task, null, delay);
                return true;
            }
            Method runDelayedRunnable = SchedulerAdapter.findMethod(scheduler.getClass(), "runDelayed", new Class[]{Plugin.class, Runnable.class, Long.TYPE});
            if (runDelayedRunnable != null) {
                runDelayedRunnable.invoke(scheduler, plugin, task, delay);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean scheduleDelayThenPostToEntity(Plugin plugin, Entity entity, long delay, Runnable task) {
        block14: {
            try {
                Object regionScheduler;
                Object globalScheduler = SchedulerAdapter.getGlobalRegionScheduler();
                if (globalScheduler != null) {
                    Consumer<Object> consumer = ignored -> SchedulerAdapter.deliverToEntity(plugin, entity, task);
                    Method runDelayedConsumer = SchedulerAdapter.findMethod(globalScheduler.getClass(), "runDelayed", new Class[]{Plugin.class, Consumer.class, Long.TYPE});
                    if (runDelayedConsumer != null) {
                        runDelayedConsumer.invoke(globalScheduler, plugin, consumer, delay);
                        return true;
                    }
                    Method runDelayedRunnable = SchedulerAdapter.findMethod(globalScheduler.getClass(), "runDelayed", new Class[]{Plugin.class, Runnable.class, Long.TYPE});
                    if (runDelayedRunnable != null) {
                        Runnable wrapped = () -> SchedulerAdapter.deliverToEntity(plugin, entity, task);
                        runDelayedRunnable.invoke(globalScheduler, plugin, wrapped, delay);
                        return true;
                    }
                }
                if ((regionScheduler = SchedulerAdapter.getRegionScheduler()) != null) {
                    World world = entity.getWorld();
                    if (world == null) {
                        return false;
                    }
                    int chunkX = entity.getLocation().getBlockX() >> 4;
                    int chunkZ = entity.getLocation().getBlockZ() >> 4;
                    Consumer<Object> consumer = ignored -> SchedulerAdapter.deliverToEntity(plugin, entity, task);
                    Method runDelayedConsumer = SchedulerAdapter.findMethod(regionScheduler.getClass(), "runDelayed", new Class[]{Plugin.class, World.class, Integer.TYPE, Integer.TYPE, Consumer.class, Long.TYPE});
                    if (runDelayedConsumer != null) {
                        runDelayedConsumer.invoke(regionScheduler, plugin, world, chunkX, chunkZ, consumer, delay);
                        return true;
                    }
                    Method runDelayedRunnable = SchedulerAdapter.findMethod(regionScheduler.getClass(), "runDelayed", new Class[]{Plugin.class, World.class, Integer.TYPE, Integer.TYPE, Runnable.class, Long.TYPE});
                    if (runDelayedRunnable != null) {
                        Runnable wrapped = () -> SchedulerAdapter.deliverToEntity(plugin, entity, task);
                        runDelayedRunnable.invoke(regionScheduler, plugin, world, chunkX, chunkZ, wrapped, delay);
                        return true;
                    }
                    Method execute = SchedulerAdapter.findMethod(regionScheduler.getClass(), "execute", new Class[]{Plugin.class, World.class, Integer.TYPE, Integer.TYPE, Runnable.class});
                    if (execute != null) {
                        Runnable wrapped = () -> SchedulerAdapter.deliverToEntity(plugin, entity, task);
                        Method runDelayedConsumerGlobal = null;
                        Object global = SchedulerAdapter.getGlobalRegionScheduler();
                        if (global != null) {
                            runDelayedConsumerGlobal = SchedulerAdapter.findMethod(global.getClass(), "runDelayed", new Class[]{Plugin.class, Consumer.class, Long.TYPE});
                            if (runDelayedConsumerGlobal != null) {
                                Consumer<Object> execConsumer = ignored -> SchedulerAdapter.executeInCurrentRegion(plugin, entity, execute, wrapped);
                                runDelayedConsumerGlobal.invoke(global, plugin, execConsumer, delay);
                                return true;
                            }
                            Method runDelayedRunnableGlobal = SchedulerAdapter.findMethod(global.getClass(), "runDelayed", new Class[]{Plugin.class, Runnable.class, Long.TYPE});
                            if (runDelayedRunnableGlobal != null) {
                                Runnable execRunnable = () -> SchedulerAdapter.executeInCurrentRegion(plugin, entity, execute, wrapped);
                                runDelayedRunnableGlobal.invoke(global, plugin, execRunnable, delay);
                                return true;
                            }
                        }
                        if (SchedulerAdapter.scheduleAsyncDelay(plugin, delay, () -> SchedulerAdapter.executeInCurrentRegion(plugin, entity, execute, wrapped))) {
                            return true;
                        }
                    }
                    break block14;
                }
                return SchedulerAdapter.scheduleAsyncDelay(plugin, delay, () -> SchedulerAdapter.deliverToEntity(plugin, entity, task));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static void executeInCurrentRegion(Plugin plugin, Entity entity, Method execute, Runnable task) {
        try {
            Object regionScheduler = SchedulerAdapter.getRegionScheduler();
            if (regionScheduler == null) {
                SchedulerAdapter.deliverToEntity(plugin, entity, task);
                return;
            }
            World world = entity.getWorld();
            if (world == null) {
                return;
            }
            int chunkX = entity.getLocation().getBlockX() >> 4;
            int chunkZ = entity.getLocation().getBlockZ() >> 4;
            execute.invoke(regionScheduler, plugin, world, chunkX, chunkZ, task);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean scheduleAsyncDelay(Plugin plugin, long delay, Runnable task) {
        try {
            Method getAsyncScheduler = Bukkit.class.getMethod("getAsyncScheduler", new Class[0]);
            Object asyncScheduler = getAsyncScheduler.invoke(null, new Object[0]);
            Method runDelayedConsumer = SchedulerAdapter.findMethod(asyncScheduler.getClass(), "runDelayed", new Class[]{Plugin.class, Consumer.class, Long.TYPE});
            if (runDelayedConsumer != null) {
                runDelayedConsumer.invoke(asyncScheduler, plugin, ignored -> task.run(), delay);
                return true;
            }
            Method runDelayedRunnable = SchedulerAdapter.findMethod(asyncScheduler.getClass(), "runDelayed", new Class[]{Plugin.class, Runnable.class, Long.TYPE});
            if (runDelayedRunnable != null) {
                runDelayedRunnable.invoke(asyncScheduler, plugin, task, delay);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean safePostToEntity(Plugin plugin, Entity entity, Runnable task) {
        try {
            Object scheduler = SchedulerAdapter.getEntityScheduler(entity);
            Method runConsumerRetired = SchedulerAdapter.findMethod(scheduler.getClass(), "run", new Class[]{Plugin.class, Consumer.class, Runnable.class});
            if (runConsumerRetired != null) {
                runConsumerRetired.invoke(scheduler, plugin, ignored -> task.run(), null);
                return true;
            }
            Method runConsumer = SchedulerAdapter.findMethod(scheduler.getClass(), "run", new Class[]{Plugin.class, Consumer.class});
            if (runConsumer != null) {
                runConsumer.invoke(scheduler, plugin, ignored -> task.run());
                return true;
            }
            Method runRunnableRetired = SchedulerAdapter.findMethod(scheduler.getClass(), "run", new Class[]{Plugin.class, Runnable.class, Runnable.class});
            if (runRunnableRetired != null) {
                runRunnableRetired.invoke(scheduler, plugin, task, null);
                return true;
            }
            Method runRunnable = SchedulerAdapter.findMethod(scheduler.getClass(), "run", new Class[]{Plugin.class, Runnable.class});
            if (runRunnable != null) {
                runRunnable.invoke(scheduler, plugin, task);
                return true;
            }
            Method executeRetired = SchedulerAdapter.findMethod(scheduler.getClass(), "execute", new Class[]{Plugin.class, Runnable.class, Runnable.class, Long.TYPE});
            if (executeRetired != null) {
                executeRetired.invoke(scheduler, plugin, task, null, 1L);
                return true;
            }
            Method execute = SchedulerAdapter.findMethod(scheduler.getClass(), "execute", new Class[]{Plugin.class, Runnable.class});
            if (execute != null) {
                execute.invoke(scheduler, plugin, task);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static Object getEntityScheduler(Entity entity) throws Exception {
        Method getScheduler = entity.getClass().getMethod("getScheduler", new Class[0]);
        return getScheduler.invoke((Object)entity, new Object[0]);
    }

    private static Object getGlobalRegionScheduler() {
        try {
            Method method = Bukkit.getServer().getClass().getMethod("getGlobalRegionScheduler", new Class[0]);
            return method.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Object getRegionScheduler() {
        try {
            Method method = Bukkit.getServer().getClass().getMethod("getRegionScheduler", new Class[0]);
            return method.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Method findMethod(Class<?> owner, String name, Class<?>[] desired) {
        for (Method method : owner.getMethods()) {
            Class<?>[] params;
            if (!method.getName().equals(name) || (params = method.getParameterTypes()).length != desired.length) continue;
            boolean match = true;
            for (int i = 0; i < params.length; ++i) {
                if (SchedulerAdapter.isCompatible(params[i], desired[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            try {
                method.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return method;
        }
        return null;
    }

    private static boolean isCompatible(Class<?> have, Class<?> want) {
        if (want == Plugin.class) {
            return SchedulerAdapter.isPluginType(have);
        }
        if (want == Consumer.class) {
            return SchedulerAdapter.isConsumerType(have);
        }
        if (want == Runnable.class) {
            return Runnable.class.isAssignableFrom(have);
        }
        if (want == Long.TYPE) {
            return have == Long.TYPE || have == Long.class || have == Long.TYPE;
        }
        if (want == Integer.TYPE) {
            return have == Integer.TYPE || have == Integer.class || have == Integer.TYPE;
        }
        if (want == World.class) {
            return have != null && (have == World.class || World.class.isAssignableFrom(have));
        }
        return want.isAssignableFrom(have);
    }

    private static boolean isPluginType(Class<?> c) {
        return c != null && (c.getName().equals("org.bukkit.plugin.Plugin") || Plugin.class.isAssignableFrom(c));
    }

    private static boolean isConsumerType(Class<?> c) {
        return c != null && (c.getName().equals("java.util.function.Consumer") || Consumer.class.isAssignableFrom(c));
    }

    private static void deliverToEntity(Plugin plugin, Entity entity, Runnable task) {
        if (!SchedulerAdapter.safePostToEntity(plugin, entity, task)) {
            SchedulerAdapter.warnOnce(plugin, null);
            task.run();
        }
    }

    private static void warnOnce(Plugin plugin, Throwable cause) {
        if (!WARNED_FOLIA_FAILURE.compareAndSet(false, true)) {
            return;
        }
        String message = "NoHitDelay could not schedule a delayed task on Folia; executing immediately as a fallback. Please report this.";
        if (cause != null) {
            plugin.getLogger().warning(message + " Reason: " + cause.getMessage());
        } else {
            plugin.getLogger().warning(message);
        }
    }

    static {
        boolean folia;
        WARNED_FOLIA_FAILURE = new AtomicBoolean(false);
        try {
            Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]);
            folia = true;
        }
        catch (NoSuchMethodException ignored) {
            folia = false;
        }
        FOLIA_AVAILABLE = folia;
    }
}

