/*
 * Decompiled with CFR 0.152.
 */
package newamazingpvp.nohitdelay;

import newamazingpvp.nohitdelay.Config;
import newamazingpvp.nohitdelay.NoHitDelay;
import newamazingpvp.nohitdelay.SchedulerAdapter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class Events
implements Listener {
    private final NoHitDelay plugin;
    private final Config config;

    public Events(NoHitDelay plugin, Config config) {
        this.plugin = plugin;
        this.config = config;
    }

    @EventHandler
    private void onEntityDamage(EntityDamageByEntityEvent event) {
        long hitDelay = this.config.getConfig().getLong("delay");
        String mode = this.config.getConfig().getString("mode");
        Entity damager = event.getDamager();
        Entity entity = event.getEntity();
        if (mode != null) {
            switch (mode.toLowerCase()) {
                case "pvp": {
                    if (!(damager instanceof Player) || !(entity instanceof Player)) break;
                    this.resetNoDamageTicks((LivingEntity)entity, hitDelay);
                    break;
                }
                case "evp": {
                    if (damager instanceof Player || !(entity instanceof Player)) break;
                    this.resetNoDamageTicks((LivingEntity)entity, hitDelay);
                    break;
                }
                case "pvp-evp": {
                    if ((!(damager instanceof Player) || !(entity instanceof LivingEntity)) && (!(entity instanceof Player) || !(damager instanceof LivingEntity))) break;
                    this.resetNoDamageTicks((LivingEntity)entity, hitDelay);
                    break;
                }
                case "any": {
                    if (!(entity instanceof LivingEntity)) break;
                    this.resetNoDamageTicks((LivingEntity)entity, hitDelay);
                    break;
                }
                case "player-only": {
                    if (!(damager instanceof Player) || !(entity instanceof LivingEntity)) break;
                    this.resetNoDamageTicks((LivingEntity)entity, hitDelay);
                }
            }
        }
    }

    private void resetNoDamageTicks(LivingEntity entity, long hitDelay) {
        double multiplier = this.config.getConfig().getDouble("knockback-multiplier");
        if (Math.abs(multiplier - 1.0) > 1.0E-4) {
            SchedulerAdapter.runEntityLater((Plugin)this.plugin, (Entity)entity, 1L, () -> entity.setVelocity(entity.getVelocity().multiply(multiplier)));
        }
        SchedulerAdapter.runEntityLater((Plugin)this.plugin, (Entity)entity, 1L, () -> entity.setNoDamageTicks((int)Math.max(0L, hitDelay)));
    }
}

