/*
 * Decompiled with CFR 0.152.
 */
package newamazingpvp.nohitdelay;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public final class SchedulerAdapter {
    private static final boolean FOLIA_AVAILABLE;

    private SchedulerAdapter() {
    }

    public static boolean isFolia() {
        return FOLIA_AVAILABLE;
    }

    public static void runEntityLater(Plugin plugin, Entity entity, long delayTicks, Runnable task) {
        Objects.requireNonNull(plugin, "plugin");
        Objects.requireNonNull(entity, "entity");
        Objects.requireNonNull(task, "task");
        long delay = Math.max(0L, delayTicks);
        if (!FOLIA_AVAILABLE) {
            Bukkit.getScheduler().runTaskLater(plugin, task, delay);
            return;
        }
        try {
            Method getScheduler = entity.getClass().getMethod("getScheduler", new Class[0]);
            Object scheduler = getScheduler.invoke((Object)entity, new Object[0]);
            Method runDelayed = null;
            for (Method m : scheduler.getClass().getMethods()) {
                Class<?>[] params;
                if (!m.getName().equals("runDelayed") || (params = m.getParameterTypes()).length != 3 || !SchedulerAdapter.isPluginType(params[0]) || !SchedulerAdapter.isConsumerType(params[1]) || params[2] != Long.TYPE && params[2] != Long.class) continue;
                runDelayed = m;
                break;
            }
            if (runDelayed == null) {
                throw new NoSuchMethodException("EntityScheduler#runDelayed not found");
            }
            Consumer<Object> consumer = ignored -> task.run();
            runDelayed.invoke(scheduler, plugin, consumer, delay);
        }
        catch (Throwable t) {
            Bukkit.getScheduler().runTaskLater(plugin, task, delay);
        }
    }

    private static boolean isPluginType(Class<?> c) {
        return c != null && (c.getName().equals("org.bukkit.plugin.Plugin") || Plugin.class.isAssignableFrom(c));
    }

    private static boolean isConsumerType(Class<?> c) {
        return c != null && (c.getName().equals("java.util.function.Consumer") || Consumer.class.isAssignableFrom(c));
    }

    static {
        boolean folia;
        try {
            Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]);
            folia = true;
        }
        catch (NoSuchMethodException e) {
            folia = false;
        }
        FOLIA_AVAILABLE = folia;
    }
}

