/*
 * Decompiled with CFR 0.152.
 */
package newamazingpvp.shaded.retrooper.packetevents.protocol.world.painting;

import newamazingpvp.shaded.retrooper.packetevents.manager.server.ServerVersion;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.CopyableEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.MappedEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBT;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBTCompound;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBTInt;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBTString;
import newamazingpvp.shaded.retrooper.packetevents.protocol.player.ClientVersion;
import newamazingpvp.shaded.retrooper.packetevents.protocol.world.painting.PaintingVariants;
import newamazingpvp.shaded.retrooper.packetevents.protocol.world.painting.StaticPaintingVariant;
import newamazingpvp.shaded.retrooper.packetevents.resources.ResourceLocation;
import newamazingpvp.shaded.retrooper.packetevents.util.mappings.TypesBuilderData;
import newamazingpvp.shaded.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface PaintingVariant
extends MappedEntity,
CopyableEntity<PaintingVariant>,
DeepComparableEntity {
    public int getWidth();

    public int getHeight();

    public ResourceLocation getAssetId();

    public static PaintingVariant read(PacketWrapper<?> wrapper) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21)) {
            return wrapper.readMappedEntityOrDirect(PaintingVariants.getRegistry(), PaintingVariant::readDirect);
        }
        return wrapper.readMappedEntity(PaintingVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, PaintingVariant variant) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21)) {
            wrapper.writeMappedEntityOrDirect(variant, PaintingVariant::writeDirect);
        } else {
            wrapper.writeMappedEntity(variant);
        }
    }

    public static PaintingVariant readDirect(PacketWrapper<?> wrapper) {
        int width = wrapper.readVarInt();
        int height = wrapper.readVarInt();
        ResourceLocation assetId = wrapper.readIdentifier();
        return new StaticPaintingVariant(width, height, assetId);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, PaintingVariant variant) {
        wrapper.writeVarInt(variant.getWidth());
        wrapper.writeVarInt(variant.getHeight());
        wrapper.writeIdentifier(variant.getAssetId());
    }

    public static PaintingVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        int width = compound.getNumberTagOrThrow("width").getAsInt();
        int height = compound.getNumberTagOrThrow("height").getAsInt();
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticPaintingVariant(data, width, height, assetId);
    }

    public static NBT encode(PaintingVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("width", new NBTInt(variant.getWidth()));
        compound.setTag("height", new NBTInt(variant.getHeight()));
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

