/*
 * Decompiled with CFR 0.152.
 */
package newamazingpvp.shaded.retrooper.packetevents.protocol.potion;

import newamazingpvp.shaded.retrooper.packetevents.protocol.potion.PotionType;
import newamazingpvp.shaded.retrooper.packetevents.protocol.potion.PotionTypes;
import newamazingpvp.shaded.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public class PotionEffect {
    private final PotionType type;
    private final Properties properties;

    public PotionEffect(PotionType type, int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon, @Nullable Properties hiddenEffect) {
        this(type, new Properties(amplifier, duration, ambient, showParticles, showIcon, hiddenEffect));
    }

    public PotionEffect(PotionType type, Properties properties) {
        this.type = type;
        this.properties = properties;
    }

    public static PotionEffect read(PacketWrapper<?> wrapper) {
        PotionType type = wrapper.readMappedEntity(PotionTypes::getById);
        Properties props = Properties.read(wrapper);
        return new PotionEffect(type, props);
    }

    public static void write(PacketWrapper<?> wrapper, PotionEffect effect) {
        wrapper.writeMappedEntity(effect.type);
        Properties.write(wrapper, effect.properties);
    }

    public static class Properties {
        private final int amplifier;
        private final int duration;
        private final boolean ambient;
        private final boolean showParticles;
        private final boolean showIcon;
        @Nullable
        private final Properties hiddenEffect;

        public Properties(int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon, @Nullable Properties hiddenEffect) {
            this.amplifier = amplifier;
            this.duration = duration;
            this.ambient = ambient;
            this.showParticles = showParticles;
            this.showIcon = showIcon;
            this.hiddenEffect = hiddenEffect;
        }

        public static Properties read(PacketWrapper<?> wrapper) {
            int amplifier = wrapper.readVarInt();
            int duration = wrapper.readVarInt();
            boolean ambient = wrapper.readBoolean();
            boolean showParticles = wrapper.readBoolean();
            boolean showIcon = wrapper.readBoolean();
            Properties hiddenEffect = (Properties)wrapper.readOptional(Properties::read);
            return new Properties(amplifier, duration, ambient, showParticles, showIcon, hiddenEffect);
        }

        public static void write(PacketWrapper<?> wrapper, Properties props) {
            wrapper.writeVarInt(props.amplifier);
            wrapper.writeVarInt(props.duration);
            wrapper.writeBoolean(props.ambient);
            wrapper.writeBoolean(props.showParticles);
            wrapper.writeBoolean(props.showIcon);
            wrapper.writeOptional(props.hiddenEffect, Properties::write);
        }
    }
}

