/*
 * Decompiled with CFR 0.152.
 */
package newamazingpvp.shaded.retrooper.packetevents.protocol.entity.cat;

import newamazingpvp.shaded.retrooper.packetevents.protocol.entity.cat.CatVariants;
import newamazingpvp.shaded.retrooper.packetevents.protocol.entity.cat.StaticCatVariant;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.CopyableEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.MappedEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBT;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBTCompound;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBTString;
import newamazingpvp.shaded.retrooper.packetevents.protocol.player.ClientVersion;
import newamazingpvp.shaded.retrooper.packetevents.resources.ResourceLocation;
import newamazingpvp.shaded.retrooper.packetevents.util.mappings.TypesBuilderData;
import newamazingpvp.shaded.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface CatVariant
extends MappedEntity,
CopyableEntity<CatVariant>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    public static CatVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(CatVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, CatVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static CatVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticCatVariant(data, assetId);
    }

    public static NBT encode(CatVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

