/*
 * Decompiled with CFR 0.152.
 */
package newamazingpvp.shaded.retrooper.packetevents.util;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PEVersion
implements Comparable<PEVersion> {
    private final int major;
    private final int minor;
    private final int patch;
    private final boolean snapshot;
    @Nullable
    private final String snapshotCommit;

    public PEVersion(int major, int minor, int patch, boolean snapshot, @Nullable String snapshotCommit) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.snapshot = snapshot;
        this.snapshotCommit = snapshotCommit;
    }

    public PEVersion(int major, int minor, int patch, @Nullable String snapshotCommit) {
        this(major, minor, patch, snapshotCommit != null, snapshotCommit);
    }

    public PEVersion(int major, int minor, int patch, boolean snapshot) {
        this(major, minor, patch, snapshot, null);
    }

    public PEVersion(int major, int minor, int patch) {
        this(major, minor, patch, false);
    }

    @Deprecated
    public PEVersion(int ... version) {
        this(version[0], version[1], version[2]);
    }

    @Deprecated
    public PEVersion(@NotNull String version) {
        String[] parts;
        String versionWithoutSnapshot = version.replace("-SNAPSHOT", "");
        String[] largeParts = versionWithoutSnapshot.split("\\+");
        String[] stringArray = parts = largeParts.length > 0 ? largeParts[0].split("\\.") : null;
        if (largeParts.length < 1 || largeParts.length > 2 || parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException("Version string must be in the format 'major.minor[.patch][+commit][-SNAPSHOT]', found '" + version + "' instead");
        }
        this.major = Integer.parseInt(parts[0]);
        this.minor = Integer.parseInt(parts[1]);
        this.patch = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
        this.snapshot = version.contains("-SNAPSHOT");
        this.snapshotCommit = largeParts.length > 1 ? largeParts[1] : null;
    }

    public static PEVersion fromString(@NotNull String version) {
        return new PEVersion(version);
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public boolean snapshot() {
        return this.snapshot;
    }

    @Nullable
    public String snapshotCommit() {
        return this.snapshotCommit;
    }

    @Override
    public int compareTo(@NotNull PEVersion other) {
        int majorCompare = Integer.compare(this.major, other.major);
        if (majorCompare != 0) {
            return majorCompare;
        }
        int minorCompare = Integer.compare(this.minor, other.minor);
        if (minorCompare != 0) {
            return minorCompare;
        }
        int patchCompare = Integer.compare(this.patch, other.patch);
        if (patchCompare != 0) {
            return patchCompare;
        }
        return Boolean.compare(other.snapshot, this.snapshot);
    }

    public boolean equals(@NotNull Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PEVersion)) {
            return false;
        }
        PEVersion other = (PEVersion)obj;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch && this.snapshot == other.snapshot && Objects.equals(this.snapshotCommit, other.snapshotCommit);
    }

    public boolean isNewerThan(@NotNull PEVersion otherVersion) {
        return this.compareTo(otherVersion) > 0;
    }

    public boolean isOlderThan(@NotNull PEVersion otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.snapshot, this.snapshotCommit);
    }

    public PEVersion clone() {
        return new PEVersion(this.major, this.minor, this.patch, this.snapshot, this.snapshotCommit);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + (this.snapshot && this.snapshotCommit != null ? "+" + this.snapshotCommit + "-SNAPSHOT" : "");
    }

    public String toStringWithoutSnapshot() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    @Deprecated
    public int[] asArray() {
        return new int[]{this.major, this.minor, this.patch};
    }
}

