/*
 * Decompiled with CFR 0.152.
 */
package newamazingpvp.shaded.retrooper.packetevents.resources;

import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBT;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBTString;
import newamazingpvp.shaded.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ResourceLocation
implements Keyed {
    public static final String VANILLA_NAMESPACE = "minecraft";
    protected final String namespace;
    protected final String key;

    public ResourceLocation(Key key) {
        this(key.namespace(), key.value());
    }

    public ResourceLocation(String namespace, String key) {
        this.namespace = namespace;
        this.key = key;
    }

    public ResourceLocation(String location) {
        String[] array = new String[]{VANILLA_NAMESPACE, location};
        int index = location.indexOf(":");
        if (index != -1) {
            array[1] = location.substring(index + 1);
            if (index >= 1) {
                array[0] = location.substring(0, index);
            }
        }
        this.namespace = array[0];
        this.key = array[1];
    }

    public static ResourceLocation read(PacketWrapper<?> wrapper) {
        return wrapper.readIdentifier();
    }

    public static void write(PacketWrapper<?> wrapper, ResourceLocation resourceLocation) {
        wrapper.writeIdentifier(resourceLocation);
    }

    public static ResourceLocation decode(NBT nbt, PacketWrapper<?> wrapper) {
        return new ResourceLocation(((NBTString)nbt).getValue());
    }

    public static NBT encode(PacketWrapper<?> wrapper, ResourceLocation resourceLocation) {
        return new NBTString(resourceLocation.toString());
    }

    public static String getNamespace(String location) {
        int namespaceIdx = location.indexOf(58);
        if (namespaceIdx > 0) {
            return location.substring(0, namespaceIdx);
        }
        return VANILLA_NAMESPACE;
    }

    public static String getPath(String location) {
        int namespaceIdx = location.indexOf(58);
        if (namespaceIdx != -1) {
            return location.substring(namespaceIdx + 1);
        }
        return location;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String normString(@Nullable String location) {
        if (location == null) {
            return null;
        }
        int index = location.indexOf(58);
        if (index > 0) {
            return location;
        }
        if (index == -1) {
            return "minecraft:" + location;
        }
        return VANILLA_NAMESPACE + location;
    }

    @Override
    public Key key() {
        return Key.key(this.namespace, this.key);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.key);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceLocation) {
            ResourceLocation other = (ResourceLocation)obj;
            return other.namespace.equals(this.namespace) && other.key.equals(this.key);
        }
        return false;
    }

    public String toString() {
        return this.namespace + ":" + this.key;
    }

    public static ResourceLocation minecraft(String key) {
        return new ResourceLocation(VANILLA_NAMESPACE, key);
    }
}

