/*
 * Decompiled with CFR 0.152.
 */
package newamazingpvp.shaded.retrooper.packetevents.protocol.world.biome;

import java.util.Optional;
import net.kyori.adventure.util.Index;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.CopyableEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.MappedEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBT;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBTByte;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBTCompound;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBTFloat;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBTString;
import newamazingpvp.shaded.retrooper.packetevents.protocol.player.ClientVersion;
import newamazingpvp.shaded.retrooper.packetevents.protocol.world.biome.BiomeEffects;
import newamazingpvp.shaded.retrooper.packetevents.protocol.world.biome.StaticBiome;
import newamazingpvp.shaded.retrooper.packetevents.util.adventure.AdventureIndexUtil;
import newamazingpvp.shaded.retrooper.packetevents.util.mappings.TypesBuilderData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface Biome
extends MappedEntity,
CopyableEntity<Biome>,
DeepComparableEntity {
    public boolean hasPrecipitation();

    @ApiStatus.Obsolete(since="1.19.3")
    public Precipitation getPrecipitation();

    public float getTemperature();

    public TemperatureModifier getTemperatureModifier();

    public float getDownfall();

    @ApiStatus.Obsolete(since="1.19")
    @Nullable
    public Category getCategory();

    @ApiStatus.Obsolete(since="1.18")
    @Nullable
    public Float getDepth();

    @ApiStatus.Obsolete(since="1.18")
    @Nullable
    public Float getScale();

    public BiomeEffects getEffects();

    public static Biome decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        float temperature = compound.getNumberTagOrThrow("temperature").getAsFloat();
        TemperatureModifier temperatureModifier = Optional.ofNullable(compound.getStringTagValueOrNull("temperature_modifier")).map(id -> AdventureIndexUtil.indexValueOrThrow(TemperatureModifier.ID_INDEX, id)).orElse(TemperatureModifier.NONE);
        float downfall = compound.getNumberTagOrThrow("downfall").getAsFloat();
        boolean precipitation = version.isNewerThan(ClientVersion.V_1_19_3) ? compound.getBoolean("has_precipitation") : AdventureIndexUtil.indexValueOrThrow(Precipitation.ID_INDEX, compound.getStringTagValueOrThrow("precipitation")) != Precipitation.NONE;
        BiomeEffects effects = BiomeEffects.decode(compound.getTagOrThrow("effects"), version);
        Category category = version.isNewerThanOrEquals(ClientVersion.V_1_19) ? null : AdventureIndexUtil.indexValueOrThrow(Category.ID_INDEX, compound.getStringTagValueOrThrow("category"));
        Float depth = version.isNewerThanOrEquals(ClientVersion.V_1_18) ? null : Float.valueOf(compound.getNumberTagOrThrow("depth").getAsFloat());
        Float scale = version.isNewerThanOrEquals(ClientVersion.V_1_18) ? null : Float.valueOf(compound.getNumberTagOrThrow("scale").getAsFloat());
        return new StaticBiome(data, precipitation, temperature, temperatureModifier, downfall, category, depth, scale, effects);
    }

    public static NBT encode(Biome biome, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        if (version.isNewerThan(ClientVersion.V_1_19_3)) {
            compound.setTag("has_precipitation", new NBTByte(biome.hasPrecipitation()));
        } else {
            compound.setTag("precipitation", new NBTString(biome.getPrecipitation().getId()));
        }
        compound.setTag("temperature", new NBTFloat(biome.getTemperature()));
        if (biome.getTemperatureModifier() != TemperatureModifier.NONE) {
            compound.setTag("temperature_modifier", new NBTString(biome.getTemperatureModifier().getId()));
        }
        compound.setTag("downfall", new NBTFloat(biome.getDownfall()));
        if (version.isOlderThan(ClientVersion.V_1_19)) {
            if (biome.getCategory() != null) {
                compound.setTag("category", new NBTString(biome.getCategory().getId()));
            }
            if (version.isOlderThan(ClientVersion.V_1_18)) {
                if (biome.getDepth() != null) {
                    compound.setTag("depth", new NBTFloat(biome.getDepth().floatValue()));
                }
                if (biome.getScale() != null) {
                    compound.setTag("scale", new NBTFloat(biome.getScale().floatValue()));
                }
            }
        }
        compound.setTag("effects", BiomeEffects.encode(biome.getEffects(), version));
        return compound;
    }

    public static enum TemperatureModifier {
        NONE("none"),
        FROZEN("frozen");

        public static final Index<String, TemperatureModifier> ID_INDEX;
        private final String id;

        private TemperatureModifier(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        static {
            ID_INDEX = Index.create(TemperatureModifier.class, TemperatureModifier::getId);
        }
    }

    @ApiStatus.Obsolete(since="1.19.3")
    public static enum Precipitation {
        NONE("none"),
        RAIN("rain"),
        SNOW("snow");

        public static final Index<String, Precipitation> ID_INDEX;
        private final String id;

        private Precipitation(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        static {
            ID_INDEX = Index.create(Precipitation.class, Precipitation::getId);
        }
    }

    @ApiStatus.Obsolete(since="1.19")
    public static enum Category {
        NONE("none"),
        TAIGA("taiga"),
        EXTREME_HILLS("extreme_hills"),
        JUNGLE("jungle"),
        MESA("mesa"),
        PLAINS("plains"),
        SAVANNA("savanna"),
        ICY("icy"),
        THE_END("the_end"),
        BEACH("beach"),
        FOREST("forest"),
        OCEAN("ocean"),
        DESERT("desert"),
        RIVER("river"),
        SWAMP("swamp"),
        MUSHROOM("mushroom"),
        NETHER("nether"),
        UNDERGROUND("underground"),
        MOUNTAIN("mountain");

        public static final Index<String, Category> ID_INDEX;
        private final String id;

        private Category(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        static {
            ID_INDEX = Index.create(Category.class, Category::getId);
        }
    }
}

