/*
 * Decompiled with CFR 0.152.
 */
package newamazingpvp.shaded.retrooper.packetevents.protocol.item.enchantment.type;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import newamazingpvp.shaded.retrooper.packetevents.protocol.component.EnchantEffectComponentTypes;
import newamazingpvp.shaded.retrooper.packetevents.protocol.component.IComponentMap;
import newamazingpvp.shaded.retrooper.packetevents.protocol.component.StaticComponentMap;
import newamazingpvp.shaded.retrooper.packetevents.protocol.item.enchantment.EnchantmentDefinition;
import newamazingpvp.shaded.retrooper.packetevents.protocol.item.enchantment.type.StaticEnchantmentType;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.CopyableEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.MappedEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.MappedEntityRefSet;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.MappedEntitySet;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBT;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBTCompound;
import newamazingpvp.shaded.retrooper.packetevents.protocol.player.ClientVersion;
import newamazingpvp.shaded.retrooper.packetevents.util.mappings.TypesBuilderData;
import newamazingpvp.shaded.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface EnchantmentType
extends MappedEntity,
CopyableEntity<EnchantmentType>,
DeepComparableEntity {
    public Component getDescription();

    public EnchantmentDefinition getDefinition();

    public MappedEntitySet<EnchantmentType> getExclusiveSet();

    public MappedEntityRefSet<EnchantmentType> getExclusiveRefSet();

    public StaticComponentMap getEffects();

    @Deprecated
    public static EnchantmentType decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        return EnchantmentType.decode(nbt, PacketWrapper.createDummyWrapper(version), data);
    }

    public static EnchantmentType decode(NBT nbt, PacketWrapper<?> wrapper, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Component description = compound.getOrThrow("description", wrapper.getSerializers(), wrapper);
        EnchantmentDefinition definition = EnchantmentDefinition.decode((NBT)compound, wrapper);
        MappedEntityRefSet exclusiveSet = Optional.ofNullable(compound.getTagOrNull("exclusive_set")).map(tag -> MappedEntitySet.decodeRefSet(tag, wrapper)).orElseGet(MappedEntitySet::createEmpty);
        StaticComponentMap effects = Optional.ofNullable(compound.getTagOrNull("effects")).map(tag -> IComponentMap.decode(tag, wrapper, EnchantEffectComponentTypes.getRegistry())).orElse(StaticComponentMap.EMPTY);
        return new StaticEnchantmentType(data, description, definition, exclusiveSet, effects);
    }

    @Deprecated
    public static NBT encode(EnchantmentType type, ClientVersion version) {
        return EnchantmentType.encode(type, PacketWrapper.createDummyWrapper(version));
    }

    public static NBT encode(EnchantmentType type, PacketWrapper<?> wrapper) {
        NBTCompound compound = new NBTCompound();
        EnchantmentDefinition.encode(compound, wrapper, type.getDefinition());
        compound.set("description", type.getDescription(), wrapper.getSerializers(), wrapper);
        if (!type.getExclusiveRefSet().isEmpty()) {
            compound.set("exclusive_set", type.getExclusiveRefSet(), MappedEntitySet::encodeRefSet, wrapper);
        }
        if (!type.getEffects().isEmpty()) {
            compound.set("effects", type.getEffects(), IComponentMap::encode, wrapper);
        }
        return compound;
    }
}

