/*
 * Decompiled with CFR 0.152.
 */
package newamazingpvp.shaded.retrooper.packetevents.protocol.item.banner;

import newamazingpvp.shaded.retrooper.packetevents.protocol.item.banner.StaticBannerPattern;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.CopyableEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.mapper.MappedEntity;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBT;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBTCompound;
import newamazingpvp.shaded.retrooper.packetevents.protocol.nbt.NBTString;
import newamazingpvp.shaded.retrooper.packetevents.protocol.player.ClientVersion;
import newamazingpvp.shaded.retrooper.packetevents.resources.ResourceLocation;
import newamazingpvp.shaded.retrooper.packetevents.util.mappings.TypesBuilderData;
import newamazingpvp.shaded.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface BannerPattern
extends MappedEntity,
CopyableEntity<BannerPattern>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    public String getTranslationKey();

    public static BannerPattern readDirect(PacketWrapper<?> wrapper) {
        ResourceLocation assetId = wrapper.readIdentifier();
        String translationKey = wrapper.readString();
        return new StaticBannerPattern(assetId, translationKey);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, BannerPattern pattern) {
        wrapper.writeIdentifier(pattern.getAssetId());
        wrapper.writeString(pattern.getTranslationKey());
    }

    public static BannerPattern decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        String translationKey = compound.getStringTagValueOrThrow("translation_key");
        return new StaticBannerPattern(data, assetId, translationKey);
    }

    public static NBT encode(BannerPattern bannerPattern, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(bannerPattern.getAssetId().toString()));
        compound.setTag("translation_key", new NBTString(bannerPattern.getTranslationKey()));
        return compound;
    }
}

