/*
 * Decompiled with CFR 0.152.
 */
package newamazingpvp.betterinvisibility;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public final class FoliaCompatScheduler {
    private final Plugin plugin;

    public FoliaCompatScheduler(Class<?> pluginMainClass) {
        Plugin found = null;
        for (Plugin p : Bukkit.getPluginManager().getPlugins()) {
            if (!pluginMainClass.isInstance(p)) continue;
            found = p;
            break;
        }
        this.plugin = Objects.requireNonNull(found, "Plugin instance not found");
    }

    public TickTask runAtEntityTimer(Entity entity, final Consumer<TaskHandle> runnable, long delayTicks, long periodTicks) {
        try {
            Method getScheduler = entity.getClass().getMethod("getScheduler", new Class[0]);
            Object entityScheduler = getScheduler.invoke((Object)entity, new Object[0]);
            Class<?> scheduledTaskClass = Class.forName("io.papermc.paper.threadedregions.scheduler.ScheduledTask");
            final Method cancelMethod = scheduledTaskClass.getMethod("cancel", new Class[0]);
            Method runAtFixedRate = entityScheduler.getClass().getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE);
            final AtomicReference<Object> scheduledRef = new AtomicReference<Object>();
            Consumer<Object> foliaConsumer = new Consumer<Object>(){

                @Override
                public void accept(Object st) {
                    runnable.accept(new TaskHandle(){

                        @Override
                        public void cancel() {
                            try {
                                cancelMethod.invoke(scheduledRef.get(), new Object[0]);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
            };
            Object scheduled = runAtFixedRate.invoke(entityScheduler, this.plugin, foliaConsumer, delayTicks, periodTicks);
            scheduledRef.set(scheduled);
            return new TickTask(){

                @Override
                public void cancel() {
                    try {
                        cancelMethod.invoke(scheduledRef.get(), new Object[0]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
        }
        catch (Throwable getScheduler) {
            final AtomicInteger taskId = new AtomicInteger();
            taskId.set(Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, new Runnable(){

                @Override
                public void run() {
                    runnable.accept(new TaskHandle(){

                        @Override
                        public void cancel() {
                            try {
                                Bukkit.getScheduler().cancelTask(taskId.get());
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
            }, delayTicks, periodTicks));
            return new TickTask(){

                @Override
                public void cancel() {
                    Bukkit.getScheduler().cancelTask(taskId.get());
                }
            };
        }
    }

    public static interface TickTask
    extends TaskHandle {
    }

    public static interface TaskHandle {
        public void cancel();
    }
}

