/*
 * Decompiled with CFR 0.152.
 */
package newamazingpvp.betterinvisibility;

import newamazingpvp.betterinvisibility.ArmorManager;
import newamazingpvp.betterinvisibility.ConfigManager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EventListener
implements Listener {
    private final ConfigManager configManager;
    private final ArmorManager armorManager;
    private boolean isEffectAddedByPlugin = false;

    public EventListener(ConfigManager configManager, ArmorManager armorManager) {
        this.configManager = configManager;
        this.armorManager = armorManager;
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (event.getPlayer().hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            this.armorManager.hidePlayer(event.getPlayer());
        }
    }

    @EventHandler
    public void onPotionEffect(EntityPotionEffectEvent event) {
        if (this.isEffectAddedByPlugin) {
            this.isEffectAddedByPlugin = false;
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getNewEffect() != null && event.getNewEffect().getType() != null && event.getNewEffect().getType().equals((Object)PotionEffectType.INVISIBILITY)) {
                if (this.configManager.isHidePotionParticles()) {
                    PotionEffect potion = event.getNewEffect();
                    PotionEffect newEffect = new PotionEffect(PotionEffectType.INVISIBILITY, potion.getDuration(), potion.getAmplifier(), potion.isAmbient(), false);
                    player.removePotionEffect(PotionEffectType.INVISIBILITY);
                    this.isEffectAddedByPlugin = true;
                    player.addPotionEffect(newEffect);
                }
                this.armorManager.hidePlayer(player);
            } else if (event.getOldEffect() != null && event.getOldEffect().getType() != null && event.getOldEffect().getType().equals((Object)PotionEffectType.INVISIBILITY)) {
                this.armorManager.showPlayer(player);
            }
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.armorManager.stopTracking(event.getPlayer());
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        this.armorManager.stopTracking(event.getPlayer());
    }
}

