/*
 * Decompiled with CFR 0.152.
 */
package newamazingpvp.betterinvisibility;

import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import newamazingpvp.betterinvisibility.ConfigManager;
import newamazingpvp.shaded.retrooper.packetevents.PacketEvents;
import newamazingpvp.shaded.retrooper.packetevents.protocol.player.Equipment;
import newamazingpvp.shaded.retrooper.packetevents.protocol.player.EquipmentSlot;
import newamazingpvp.shaded.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEquipment;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ArmorManager {
    private static final newamazingpvp.shaded.retrooper.packetevents.protocol.item.ItemStack AIR_ITEM = ArmorManager.toPE(new ItemStack(Material.AIR));
    private final ConfigManager configManager;
    private final Set<Integer> invisible = ConcurrentHashMap.newKeySet();

    public ArmorManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void hidePlayer(Player player) {
        this.invisible.add(player.getEntityId());
        this.sendEquipment(player, true);
    }

    public void showPlayer(Player player) {
        this.sendEquipment(player, false);
        this.invisible.remove(player.getEntityId());
    }

    public void stopTracking(Player player) {
        this.invisible.remove(player.getEntityId());
    }

    public boolean isInvisible(int entityId) {
        return this.invisible.contains(entityId);
    }

    public void maskPacket(WrapperPlayServerEntityEquipment packet) {
        ArrayList<Equipment> equipment = new ArrayList<Equipment>();
        if (this.configManager.isHideBoots()) {
            equipment.add(new Equipment(EquipmentSlot.BOOTS, AIR_ITEM));
        }
        if (this.configManager.isHideLeggings()) {
            equipment.add(new Equipment(EquipmentSlot.LEGGINGS, AIR_ITEM));
        }
        if (this.configManager.isHideChestplate()) {
            equipment.add(new Equipment(EquipmentSlot.CHEST_PLATE, AIR_ITEM));
        }
        if (this.configManager.isHideHelmet()) {
            equipment.add(new Equipment(EquipmentSlot.HELMET, AIR_ITEM));
        }
        if (this.configManager.isHideMainhand()) {
            equipment.add(new Equipment(EquipmentSlot.MAIN_HAND, AIR_ITEM));
        }
        if (this.configManager.isHideOffhand()) {
            equipment.add(new Equipment(EquipmentSlot.OFF_HAND, AIR_ITEM));
        }
        packet.setEquipment(equipment);
    }

    private void sendEquipment(Player player, boolean air) {
        ArrayList<Equipment> equipment = new ArrayList<Equipment>();
        if (this.configManager.isHideBoots()) {
            equipment.add(new Equipment(EquipmentSlot.BOOTS, air ? AIR_ITEM : ArmorManager.toPE(player.getInventory().getBoots())));
        }
        if (this.configManager.isHideLeggings()) {
            equipment.add(new Equipment(EquipmentSlot.LEGGINGS, air ? AIR_ITEM : ArmorManager.toPE(player.getInventory().getLeggings())));
        }
        if (this.configManager.isHideChestplate()) {
            equipment.add(new Equipment(EquipmentSlot.CHEST_PLATE, air ? AIR_ITEM : ArmorManager.toPE(player.getInventory().getChestplate())));
        }
        if (this.configManager.isHideHelmet()) {
            equipment.add(new Equipment(EquipmentSlot.HELMET, air ? AIR_ITEM : ArmorManager.toPE(player.getInventory().getHelmet())));
        }
        if (this.configManager.isHideMainhand()) {
            ItemStack main = ArmorManager.getMainHand(player);
            equipment.add(new Equipment(EquipmentSlot.MAIN_HAND, air ? AIR_ITEM : ArmorManager.toPE(main)));
        }
        if (this.configManager.isHideOffhand()) {
            ItemStack off = ArmorManager.getOffHand(player);
            if (off != null) {
                equipment.add(new Equipment(EquipmentSlot.OFF_HAND, air ? AIR_ITEM : ArmorManager.toPE(off)));
            } else if (air) {
                equipment.add(new Equipment(EquipmentSlot.OFF_HAND, AIR_ITEM));
            }
        }
        WrapperPlayServerEntityEquipment packet = new WrapperPlayServerEntityEquipment(player.getEntityId(), equipment);
        this.sendToWorldViewers(player, packet);
    }

    private void sendToWorldViewers(Player subject, WrapperPlayServerEntityEquipment packet) {
        for (Player viewer : subject.getWorld().getPlayers()) {
            if (viewer.equals(subject)) continue;
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)viewer, packet);
        }
    }

    private static newamazingpvp.shaded.retrooper.packetevents.protocol.item.ItemStack toPE(ItemStack bukkitItem) {
        if (bukkitItem == null) {
            return AIR_ITEM;
        }
        return SpigotConversionUtil.fromBukkitItemStack(bukkitItem);
    }

    private static ItemStack getMainHand(Player player) {
        try {
            return player.getInventory().getItemInMainHand();
        }
        catch (NoSuchMethodError e) {
            return player.getInventory().getItemInHand();
        }
    }

    private static ItemStack getOffHand(Player player) {
        try {
            return player.getInventory().getItemInOffHand();
        }
        catch (NoSuchMethodError e) {
            return null;
        }
    }
}

