/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.manager;

import io.github.retrooper.packetevents.injector.SpigotChannelInjector;
import io.github.retrooper.packetevents.manager.player.PlayerManagerImpl;
import io.github.retrooper.packetevents.util.protocolsupport.ProtocolSupportUtil;
import io.github.retrooper.packetevents.util.viaversion.ViaVersionUtil;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import newamazingpvp.shaded.retrooper.packetevents.PacketEvents;
import newamazingpvp.shaded.retrooper.packetevents.PacketEventsAPI;
import newamazingpvp.shaded.retrooper.packetevents.event.PacketReceiveEvent;
import newamazingpvp.shaded.retrooper.packetevents.event.PacketSendEvent;
import newamazingpvp.shaded.retrooper.packetevents.manager.InternalPacketListener;
import newamazingpvp.shaded.retrooper.packetevents.protocol.ConnectionState;
import newamazingpvp.shaded.retrooper.packetevents.protocol.packettype.PacketType;
import newamazingpvp.shaded.retrooper.packetevents.protocol.player.ClientVersion;
import newamazingpvp.shaded.retrooper.packetevents.protocol.player.User;
import newamazingpvp.shaded.retrooper.packetevents.util.LogManager;
import newamazingpvp.shaded.retrooper.packetevents.wrapper.handshaking.client.WrapperHandshakingClientHandshake;
import newamazingpvp.shaded.retrooper.packetevents.wrapper.login.server.WrapperLoginServerLoginSuccess;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class InternalBukkitPacketListener
extends InternalPacketListener {
    @Override
    public void onPacketSend(PacketSendEvent event) {
        super.onPacketSend(event);
        if (event.getPacketType() == PacketType.Login.Server.LOGIN_SUCCESS) {
            WrapperLoginServerLoginSuccess packet = new WrapperLoginServerLoginSuccess(event);
            this.tryUpdatePlayerReference(event, event.getUser(), packet.getUserProfile().getUUID());
        } else if (event.getPacketType() == PacketType.Play.Server.JOIN_GAME) {
            this.tryUpdatePlayerReference(event, event.getUser(), event.getUser().getUUID());
        }
    }

    private void tryUpdatePlayerReference(PacketSendEvent event, User user, UUID playerId) {
        Player player;
        PacketEventsAPI<?> api = PacketEvents.getAPI();
        Map<UUID, WeakReference<Player>> map = ((PlayerManagerImpl)api.getPlayerManager()).joiningPlayers;
        WeakReference<Player> playerRef = map.remove(playerId);
        Player player2 = player = playerRef != null ? (Player)playerRef.get() : null;
        if (player != null) {
            ((SpigotChannelInjector)api.getInjector()).updatePlayer(user, player);
            if (api.getLogManager().isDebug()) {
                api.getLogManager().debug("Updated player reference on packet handling for " + player.getUniqueId());
            }
            event.setPlayer(player);
        }
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Handshaking.Client.HANDSHAKE) {
            String feature;
            User user = event.getUser();
            WrapperHandshakingClientHandshake packet = new WrapperHandshakingClientHandshake(event);
            ClientVersion clientVersion = packet.getClientVersion();
            ConnectionState state = packet.getNextConnectionState();
            if (ViaVersionUtil.isAvailable()) {
                clientVersion = ClientVersion.getById(ViaVersionUtil.getProtocolVersion(user));
                feature = "ViaVersion";
            } else if (ProtocolSupportUtil.isAvailable()) {
                clientVersion = ClientVersion.getById(ProtocolSupportUtil.getProtocolVersion(user.getAddress()));
                feature = "ProtocolSupport";
            } else {
                feature = null;
            }
            LogManager logger = PacketEvents.getAPI().getLogManager();
            if (logger.isDebug()) {
                logger.debug("Processed handshake for " + event.getAddress() + ": " + state.name() + " / " + packet.getClientVersion().getReleaseName() + (feature != null ? " (using " + feature + ")" : ""));
            }
            user.setClientVersion(clientVersion);
            user.setConnectionState(state);
        } else {
            super.onPacketReceive(event);
        }
    }
}

