/*
 * Decompiled with CFR 0.152.
 */
package com.myst1cs04p.strength_smp;

import com.myst1cs04p.strength_smp.Main;
import com.myst1cs04p.strength_smp.StrengthItem;
import com.myst1cs04p.strength_smp.StrengthManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class StrengthCommand
implements CommandExecutor,
TabCompleter {
    private final Main plugin;
    private final StrengthManager manager;

    public StrengthCommand(Main plugin, StrengthManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (args.length == 0) {
            if (sender instanceof Player) {
                Player p = (Player)sender;
                sender.sendMessage(((TextComponent)Component.text((String)"[Strength] ", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)"Your strength: ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((int)this.manager.getStrength(p), (TextColor)NamedTextColor.GOLD)));
            } else if (sender.hasPermission("strength.set")) {
                sender.sendMessage((Component)Component.text((String)("Usage: /" + label + " <get|set|withdraw|reload|ver>"), (TextColor)NamedTextColor.YELLOW));
            } else {
                sender.sendMessage((Component)Component.text((String)("Usage: /" + label + " <get|withdraw|ver>"), (TextColor)NamedTextColor.YELLOW));
            }
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "help": {
                sender.sendMessage((Component)Component.text((String)"----- Strength Commands -----", (TextColor)NamedTextColor.YELLOW));
                sender.sendMessage(Component.text((String)("/" + label), (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)" - show your strength", (TextColor)NamedTextColor.WHITE)));
                if (sender.hasPermission("strength.get")) {
                    sender.sendMessage(((TextComponent)Component.text((String)("/" + label), (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)" check [player]", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" - check someone else's", (TextColor)NamedTextColor.WHITE)));
                } else {
                    sender.sendMessage(Component.text((String)("/" + label), (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)" check", (TextColor)NamedTextColor.WHITE)));
                }
                if (sender.hasPermission("strength.set")) {
                    sender.sendMessage(((TextComponent)Component.text((String)("/" + label), (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)" set <player> <amount>", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)" - set strength (op)", (TextColor)NamedTextColor.WHITE)));
                }
                sender.sendMessage(((TextComponent)Component.text((String)("/" + label), (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)" withdraw <amount>", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)" - convert strength into tokens", (TextColor)NamedTextColor.WHITE)));
                if (sender.hasPermission("strength.reload")) {
                    sender.sendMessage(Component.text((String)("/" + label + " reload"), (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)" - Reloads the plugin config", (TextColor)NamedTextColor.WHITE)));
                }
                sender.sendMessage(Component.text((String)("/" + label + " version"), (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)" - Displays the plugin version", (TextColor)NamedTextColor.WHITE)));
                return true;
            }
            case "get": {
                if (args.length == 1) {
                    if (!(sender instanceof Player)) {
                        sender.sendMessage((Component)Component.text((String)"Specify a player gng", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    Player p = (Player)sender;
                    sender.sendMessage(((TextComponent)Component.text((String)"[Strength] ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"Your strength: ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((int)this.manager.getStrength(p), (TextColor)NamedTextColor.GOLD)));
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage((Component)Component.text((String)"Bro isn't even online online \ud83d\ude2d", (TextColor)NamedTextColor.RED));
                    return true;
                }
                sender.sendMessage(((TextComponent)Component.text((String)"[Strength] ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(target.getName() + "'s strength: "), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((int)this.manager.getStrength(target), (TextColor)NamedTextColor.GOLD)));
                return true;
            }
            case "set": {
                int amount;
                if (!sender.hasPermission("strength.set")) {
                    sender.sendMessage((Component)Component.text((String)"You lack permission.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (args.length != 3) {
                    sender.sendMessage((Component)Component.text((String)("Usage: /" + label + " set <player> <amount>"), (TextColor)NamedTextColor.RED));
                    return true;
                }
                Player target2 = Bukkit.getPlayer((String)args[1]);
                if (target2 == null) {
                    sender.sendMessage((Component)Component.text((String)"Bro isn't even online online \ud83d\ude2d", (TextColor)NamedTextColor.RED));
                    return true;
                }
                try {
                    amount = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage((Component)Component.text((String)"gng that wasnt a number \ud83d\ude4f go back to school bro \ud83d\ude2d", (TextColor)NamedTextColor.RED));
                    return true;
                }
                this.manager.setStrength(target2, amount);
                sender.sendMessage((Component)Component.text((String)("Set " + target2.getName() + "'s strength to " + amount), (TextColor)NamedTextColor.GREEN));
                target2.sendMessage((Component)Component.text((String)("Your strength was set to " + amount), (TextColor)NamedTextColor.YELLOW));
                return true;
            }
            case "withdraw": {
                int amount;
                if (!(sender instanceof Player)) {
                    sender.sendMessage((Component)Component.text((String)"Chat only players can withdraw ts \ud83d\ude4f", (TextColor)NamedTextColor.RED));
                    return true;
                }
                Player player = (Player)sender;
                if (args.length != 2) {
                    player.sendMessage((Component)Component.text((String)("Usage: /" + label + " withdraw <amount>"), (TextColor)NamedTextColor.RED));
                    return true;
                }
                try {
                    amount = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    player.sendMessage((Component)Component.text((String)"Whatever amount u js tried to withdraw wasn't a number gng. Go back to school.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                int current = this.manager.getStrength(player);
                if (amount <= 0) {
                    player.sendMessage((Component)Component.text((String)"You can't withdraw nothing.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (current - amount < this.manager.getMinStrength()) {
                    player.sendMessage((Component)Component.text((String)"You ain't got that much strength twin \ud83e\udd40", (TextColor)NamedTextColor.RED));
                    return true;
                }
                this.manager.setStrength(player, current - amount);
                ItemStack token = StrengthItem.createStrengthToken();
                token.setAmount(amount);
                player.getInventory().addItem(new ItemStack[]{token});
                player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Withdrew ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((int)amount, (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)" strength and received ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((int)amount, (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)" tokens.", (TextColor)NamedTextColor.GREEN)));
                return true;
            }
            case "reload": {
                if (!sender.hasPermission("strength.reload")) {
                    sender.sendMessage((Component)Component.text((String)"You lack the perms to reload ts", (TextColor)NamedTextColor.RED));
                    return false;
                }
                this.manager.loadStrength();
                this.plugin.registerRecipe();
                return true;
            }
            case "version": {
                sender.sendMessage(Component.text((String)"You are running version ", (TextColor)NamedTextColor.GREEN).append(((TextComponent)Component.text((String)this.plugin.getDescription().getVersion(), (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)" of ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"Myst1c's Strength SMP", (TextColor)NamedTextColor.RED))));
                return true;
            }
        }
        sender.sendMessage((Component)Component.text((String)"Idk this command. Try /help", (TextColor)NamedTextColor.RED));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> subs = new ArrayList<String>();
            subs.add("get");
            if (sender.hasPermission("strength.set")) {
                subs.add("set");
            }
            subs.add("withdraw");
            subs.add("help");
            subs.add("version");
            if (sender.hasPermission("strength.reload")) {
                subs.add("reload");
            }
            String partial = args[0].toLowerCase();
            ArrayList<String> out = new ArrayList<String>();
            for (String s : subs) {
                if (!s.startsWith(partial)) continue;
                out.add(s);
            }
            return out;
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("get") && sender.hasPermission("strength.get") || args[0].equalsIgnoreCase("set") && sender.hasPermission("strength.set"))) {
            ArrayList<String> names = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                names.add(p.getName());
            }
            return names;
        }
        return Collections.emptyList();
    }
}

