/*
 * Decompiled with CFR 0.152.
 */
package com.myst1cs04p.strength_smp;

import com.myst1cs04p.strength_smp.Main;
import com.myst1cs04p.strength_smp.StrengthData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;

public class StrengthManager {
    private final HashMap<UUID, Integer> strengthMap = new HashMap();
    private final Main plugin;
    private final StrengthData data;
    private float damageMultiplier;
    private int minStrength;
    private int maxStrength;
    private static final UUID STRENGTH_MODIFIER_UUID = UUID.fromString("a91e682b-1306-4b5e-a63e-8a561c807b3f");

    public StrengthManager(Main plugin) {
        this.plugin = plugin;
        this.data = new StrengthData(plugin);
    }

    public void loadStrength() {
        this.minStrength = this.plugin.getConfig().getInt("min-strength");
        this.maxStrength = this.plugin.getConfig().getInt("max-strength");
        this.damageMultiplier = (float)this.plugin.getConfig().getDouble("damage-multiplier");
        for (String key : this.data.getData().getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(key);
                int value = this.data.getData().getInt(key);
                this.strengthMap.put(uuid, value);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid UUID in strength.yml: " + key);
            }
        }
    }

    public void saveAll() {
        for (Map.Entry<UUID, Integer> entry : this.strengthMap.entrySet()) {
            this.data.setStrength(entry.getKey(), entry.getValue());
        }
        this.data.save();
    }

    public void increaseStrength(Player player) {
        this.setStrength(player, this.getStrength(player) + 1);
    }

    public void decreaseStrength(Player player) {
        this.setStrength(player, this.getStrength(player) - 1);
    }

    public int getStrength(Player player) {
        return this.strengthMap.getOrDefault(player.getUniqueId(), this.data.getStrength(player.getUniqueId()));
    }

    public void setStrength(Player player, int amount) {
        amount = Math.max(this.minStrength, Math.min(this.maxStrength, amount));
        this.strengthMap.put(player.getUniqueId(), amount);
        this.data.setStrength(player.getUniqueId(), amount);
        StrengthManager.updatePlayerStrength(player, amount, this.damageMultiplier);
        this.data.save();
    }

    public static void updatePlayerStrength(Player player, int strengthLevel, float damageMultiplier) {
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        if (attribute == null) {
            return;
        }
        attribute.getModifiers().stream().filter(mod -> mod.getUniqueId().equals(STRENGTH_MODIFIER_UUID)).forEach(arg_0 -> ((AttributeInstance)attribute).removeModifier(arg_0));
        double bonusPercent = (float)strengthLevel * damageMultiplier;
        AttributeModifier modifier = new AttributeModifier(STRENGTH_MODIFIER_UUID, "custom_strength_multiplier", bonusPercent, AttributeModifier.Operation.MULTIPLY_SCALAR_1);
        attribute.addModifier(modifier);
    }

    public float getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public int getMinStrength() {
        return this.minStrength;
    }

    public int getMaxStrength() {
        return this.maxStrength;
    }
}

