/*
 * Decompiled with CFR 0.152.
 */
package com.myst1cs04p.strength_smp;

import com.myst1cs04p.strength_smp.Main;
import com.myst1cs04p.strength_smp.StrengthItem;
import com.myst1cs04p.strength_smp.StrengthManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;

public class StrengthListener
implements Listener {
    private final Main plugin;
    private final StrengthManager manager;

    public StrengthListener(Main plugin, StrengthManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    @EventHandler
    public void onPlayerKill(PlayerDeathEvent event) {
        if (!(event.getEntity().getKiller() instanceof Player)) {
            return;
        }
        Player victim = event.getEntity();
        Player killer = victim.getKiller();
        int victimStrength = this.manager.getStrength(victim);
        if (victimStrength <= this.manager.getMinStrength()) {
            return;
        }
        this.manager.decreaseStrength(victim);
        int killerStrength = this.manager.getStrength(killer);
        if (killerStrength < this.manager.getMaxStrength()) {
            this.manager.increaseStrength(killer);
        } else {
            ItemStack strengthToken = StrengthItem.createStrengthToken();
            killer.getWorld().dropItemNaturally(victim.getLocation(), strengthToken);
        }
    }
}

