/*
 * Decompiled with CFR 0.152.
 */
package com.myst1cs04p.strength_smp;

import com.myst1cs04p.strength_smp.StrengthItem;
import com.myst1cs04p.strength_smp.StrengthManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class StrengthItemListener
implements Listener {
    private final StrengthManager manager;

    public StrengthItemListener(StrengthManager manager) {
        this.manager = manager;
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (!StrengthItem.isStrengthToken(item)) {
            return;
        }
        Player player = event.getPlayer();
        int current = this.manager.getStrength(player);
        if (current >= this.manager.getMaxStrength()) {
            player.sendMessage((Component)Component.text((String)"You're already at max strength!", (TextColor)NamedTextColor.RED));
            return;
        }
        this.manager.increaseStrength(player);
        player.sendMessage(Component.text((String)"You absorbed strength! Your level is now ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((int)this.manager.getStrength(player), (TextColor)NamedTextColor.GOLD)));
        item.setAmount(item.getAmount() - 1);
    }
}

