/*
 * Decompiled with CFR 0.152.
 */
package com.myst1cs04p.strength_smp;

import com.myst1cs04p.strength_smp.Main;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class StrengthData {
    private final Main plugin;
    private File file;
    private FileConfiguration data;

    public StrengthData(Main plugin) {
        this.plugin = plugin;
        this.createFile();
    }

    private void createFile() {
        this.file = new File(this.plugin.getDataFolder(), "strength.yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create strength.yml!");
            }
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public int getStrength(UUID uuid) {
        return this.data.getInt(uuid.toString(), 0);
    }

    public void setStrength(UUID uuid, int value) {
        this.data.set(uuid.toString(), (Object)value);
    }

    public void save() {
        try {
            this.data.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save strength.yml!");
        }
    }

    public FileConfiguration getData() {
        return this.data;
    }
}

