/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.signportals.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Villager;
import org.bukkit.util.Vector;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.permissions.CorePermissionsChecker;
import org.mvplugins.multiverse.core.permissions.PermissionUtils;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.signportals.enums.Axis;
import org.mvplugins.multiverse.signportals.exceptions.MoreThanOneSignFoundException;
import org.mvplugins.multiverse.signportals.exceptions.NoMultiverseSignFoundException;
import org.mvplugins.multiverse.signportals.util.MVSPLogging;
import org.mvplugins.multiverse.signportals.utils.SignStatus;
import org.mvplugins.multiverse.signportals.utils.SignTools;

@Service
public class PortalDetector {
    public static final Pattern REDSTONE_TELEPORT_PATTERN = Pattern.compile(".*\\[([pPaAmM]|all|ALL):\\d+(:(north|NORTH|south|SOUTH|east|EAST|west|WEST|up|UP|down|DOWN))?\\]");
    private final LocationManipulation locationManipulation;
    private final CorePermissionsChecker permissionsChecker;

    @Inject
    PortalDetector(LocationManipulation locationManipulation, CorePermissionsChecker permissionsChecker) {
        this.locationManipulation = locationManipulation;
        this.permissionsChecker = permissionsChecker;
    }

    public String getNotchPortalDestination(Player p, Location l) throws MoreThanOneSignFoundException, NoMultiverseSignFoundException {
        Block block = l.getBlock();
        List<Sign> foundSigns = null;
        if (block.getType() == Material.NETHER_PORTAL) {
            if (block.getRelative(1, 0, 0).getType() == Material.NETHER_PORTAL) {
                Location portalEnd = block.getRelative(1, 0, 0).getLocation();
                Location portalStart = block.getRelative(0, 2, 0).getLocation();
                foundSigns = this.checkBlocksOutside(l.getWorld().getBlockAt(portalStart), l.getWorld().getBlockAt(portalEnd), Axis.X);
                MVSPLogging.finer("Found normal X", new Object[0]);
            } else if (block.getRelative(-1, 0, 0).getType() == Material.NETHER_PORTAL) {
                Location portalEnd = block.getLocation();
                Location portalStart = block.getRelative(-1, 2, 0).getLocation();
                foundSigns = this.checkBlocksOutside(l.getWorld().getBlockAt(portalStart), l.getWorld().getBlockAt(portalEnd), Axis.X);
                MVSPLogging.finer("Found inverse X", new Object[0]);
            } else if (block.getRelative(0, 0, 1).getType() == Material.NETHER_PORTAL) {
                Location portalEnd = block.getRelative(0, 0, 1).getLocation();
                Location portalStart = block.getRelative(0, 2, 0).getLocation();
                foundSigns = this.checkBlocksOutside(l.getWorld().getBlockAt(portalStart), l.getWorld().getBlockAt(portalEnd), Axis.Z);
                MVSPLogging.finer("Found normal Z", new Object[0]);
            } else if (block.getRelative(0, 0, -1).getType() == Material.NETHER_PORTAL) {
                Location portalEnd = block.getLocation();
                Location portalStart = block.getRelative(0, 2, -1).getLocation();
                foundSigns = this.checkBlocksOutside(l.getWorld().getBlockAt(portalStart), l.getWorld().getBlockAt(portalEnd), Axis.Z);
                MVSPLogging.finer("Found inverse Z", new Object[0]);
            }
        }
        if (foundSigns != null) {
            MVSPLogging.fine("Woo! Notch Portal!", new Object[0]);
            return this.processSigns(foundSigns, p);
        }
        MVSPLogging.fine(":( No Notch Portal Here...", new Object[0]);
        return null;
    }

    public void activateSignPortal(Player player, String type, Sign sign) {
        if (PermissionUtils.hasPermission((CommandSender)player, (String)"multiverse.signportal.validate")) {
            ChatColor colorToChange = ChatColor.DARK_GREEN;
            if (SignTools.isMVSign("mv", ChatColor.GREEN)) {
                colorToChange = ChatColor.DARK_BLUE;
                player.sendMessage("This vanilla sign portal has been " + String.valueOf(ChatColor.GREEN) + " Validated!");
            } else {
                player.sendMessage("This MV sign portal has been " + String.valueOf(ChatColor.GREEN) + " Validated!");
            }
            sign.setLine(1, SignTools.setColor(sign.getLine(1), colorToChange));
            sign.update(true);
        } else {
            player.sendMessage("Sorry you don't have permission to activate this " + type + String.valueOf(ChatColor.WHITE) + " SignPortal.");
        }
    }

    private String processSigns(List<Sign> foundSigns, Player player) throws MoreThanOneSignFoundException, NoMultiverseSignFoundException {
        Sign foundSign = null;
        Sign legacySign = null;
        Sign normalSign = null;
        for (Sign s : foundSigns) {
            if (this.getSignStatus(s) == SignStatus.NetherPortalSign) {
                if (foundSign != null) {
                    throw new MoreThanOneSignFoundException();
                }
                foundSign = s;
                continue;
            }
            if (foundSign == null && this.getSignStatus(s) == SignStatus.Legacy) {
                if (legacySign != null) {
                    throw new MoreThanOneSignFoundException();
                }
                legacySign = s;
                continue;
            }
            if (foundSign != null || this.getSignStatus(s) != SignStatus.SignPortal) continue;
            if (normalSign != null) {
                throw new MoreThanOneSignFoundException();
            }
            normalSign = s;
        }
        if (foundSign == null && legacySign == null && normalSign == null) {
            throw new NoMultiverseSignFoundException();
        }
        if (foundSign != null) {
            this.invalidateOtherSigns(foundSign, foundSigns);
            return foundSign.getLine(2);
        }
        if (legacySign != null) {
            // empty if block
        }
        if (normalSign != null) {
            MVSPLogging.fine("Migrating Normal Sign", new Object[0]);
            normalSign.setLine(1, SignTools.setColor(normalSign.getLine(1), ChatColor.DARK_BLUE));
            normalSign.update(true);
            return normalSign.getLine(2);
        }
        throw new NoMultiverseSignFoundException();
    }

    private void invalidateOtherSigns(Sign sign, List<Sign> foundSigns) {
        for (Sign s : foundSigns) {
            if (s.equals((Object)sign)) continue;
            s.setLine(1, SignTools.setColor(s.getLine(1), ChatColor.DARK_RED));
            s.update(true);
        }
    }

    public String processSign(Sign sign) {
        if (SignTools.isMVSign(sign.getLine(1), ChatColor.DARK_GREEN)) {
            MVSPLogging.finer("Found a MV Sign", new Object[0]);
            return sign.getLine(2) + sign.getLine(3);
        }
        return null;
    }

    public SignStatus getSignStatus(Sign sign) {
        if (SignTools.isMVSign(sign.getLine(1), ChatColor.DARK_GREEN)) {
            MVSPLogging.finer("Found a MV Sign (Sign Portal)", new Object[0]);
            return SignStatus.SignPortal;
        }
        if (SignTools.isMVSign(sign.getLine(1), ChatColor.DARK_BLUE)) {
            MVSPLogging.finer("Found a MV Sign (Nether Portal that has a Sign)", new Object[0]);
            return SignStatus.NetherPortalSign;
        }
        if (SignTools.isMVSign(sign.getLine(1), ChatColor.DARK_RED)) {
            MVSPLogging.finer("Found a MV Sign (Disabled)", new Object[0]);
            return SignStatus.Disabled;
        }
        if (SignTools.isMVSign(sign.getLine(1), null)) {
            MVSPLogging.finer("Found a MV Sign (Legacy)", new Object[0]);
            return SignStatus.Legacy;
        }
        return SignStatus.NotASignPortal;
    }

    public Entity[] getRedstoneTeleportEntities(Sign sign) {
        if (REDSTONE_TELEPORT_PATTERN.matcher(sign.getLine(0)).matches()) {
            int radius;
            RedstoneTeleportType type;
            String line = ChatColor.stripColor((String)sign.getLine(0).replaceAll("(\\[|\\])", ""));
            String[] data = line.split(":");
            switch (data[0].toUpperCase()) {
                case "ALL": {
                    type = RedstoneTeleportType.ALL;
                    break;
                }
                case "P": {
                    type = RedstoneTeleportType.PLAYERS;
                    break;
                }
                case "M": {
                    type = RedstoneTeleportType.MONSTERS;
                    break;
                }
                case "A": {
                    type = RedstoneTeleportType.ANIMALS;
                    break;
                }
                default: {
                    return new Entity[0];
                }
            }
            try {
                radius = Integer.valueOf(data[1]);
            }
            catch (NumberFormatException e) {
                return new Entity[0];
            }
            int xOff = 0;
            int yOff = 0;
            int zOff = 0;
            if (data.length > 2) {
                switch (data[2].toUpperCase()) {
                    case "NORTH": {
                        xOff = -radius;
                        break;
                    }
                    case "SOUTH": {
                        xOff = radius;
                        break;
                    }
                    case "EAST": {
                        zOff = -radius;
                        break;
                    }
                    case "WEST": {
                        zOff = radius;
                        break;
                    }
                    case "UP": {
                        yOff = radius;
                        break;
                    }
                    case "DOWN": {
                        yOff = -radius;
                    }
                }
            }
            Vector signVector = sign.getBlock().getLocation().toVector();
            Vector min = new Vector(signVector.getX() + (double)(xOff - radius), signVector.getY() + (double)(yOff - radius), signVector.getZ() + (double)(zOff - radius));
            Vector max = new Vector(signVector.getX() + (double)(xOff + radius), signVector.getY() + (double)(yOff + radius), signVector.getZ() + (double)(zOff + radius));
            List worldEntities = sign.getBlock().getWorld().getLivingEntities();
            ArrayList<LivingEntity> entitiesInRange = new ArrayList<LivingEntity>(worldEntities.size());
            for (LivingEntity entity : worldEntities) {
                boolean tryToAddEntity = false;
                if (type == RedstoneTeleportType.ALL) {
                    tryToAddEntity = true;
                } else if (type == RedstoneTeleportType.ANIMALS && (entity instanceof Animals || entity instanceof Squid || entity instanceof Villager)) {
                    tryToAddEntity = true;
                } else if (type == RedstoneTeleportType.MONSTERS && entity instanceof Monster) {
                    tryToAddEntity = true;
                } else if (type == RedstoneTeleportType.PLAYERS && entity instanceof HumanEntity) {
                    tryToAddEntity = true;
                }
                if (!tryToAddEntity || !entity.getLocation().toVector().isInAABB(min, max) || !entity.getLocation().toVector().isInAABB(min, max)) continue;
                MVSPLogging.finest("Found " + String.valueOf(entity) + " within range!", new Object[0]);
                entitiesInRange.add(entity);
            }
            return entitiesInRange.toArray(new Entity[entitiesInRange.size()]);
        }
        return new Entity[0];
    }

    private List<Sign> checkBlocksOutside(Block top, Block bottom, Axis a) {
        int zM;
        int xM = a == Axis.X ? 1 : 0;
        int n = zM = a == Axis.Z ? 1 : 0;
        if (top.getRelative(0, 1, 0).getType() != Material.OBSIDIAN) {
            return null;
        }
        if (top.getRelative(xM, 1, zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        MVSPLogging.finer("Found top 2", new Object[0]);
        if (bottom.getRelative(0, -1, 0).getType() != Material.OBSIDIAN) {
            return null;
        }
        if (bottom.getRelative(-1 * xM, -1, -1 * zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        MVSPLogging.finer("Found bottom 2", new Object[0]);
        if (top.getRelative(-1 * xM, 0, -1 * zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        if (top.getRelative(-1 * xM, -1, -1 * zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        if (top.getRelative(-1 * xM, -2, -1 * zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        MVSPLogging.finer("Found left 3", new Object[0]);
        if (bottom.getRelative(xM, 0, zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        if (bottom.getRelative(xM, 1, zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        if (bottom.getRelative(xM, 2, zM).getType() != Material.OBSIDIAN) {
            return null;
        }
        MVSPLogging.finer("Found right 3", new Object[0]);
        Block topper = top.getRelative(-1 - xM, 1, -1 - zM);
        Block bottomer = bottom.getRelative(1 + xM, -1, 1 + zM);
        return this.checkZoneForSigns(topper, bottomer);
    }

    private List<Sign> checkZoneForSigns(Block topper, Block bottomer) {
        Location looking = new Location(topper.getWorld(), 0.0, 0.0, 0.0);
        ArrayList<Sign> signs = new ArrayList<Sign>();
        for (int x = topper.getX(); x <= bottomer.getX(); ++x) {
            looking.setX((double)x);
            for (int y = bottomer.getY(); y <= topper.getY(); ++y) {
                looking.setY((double)y);
                for (int z = topper.getZ(); z <= bottomer.getZ(); ++z) {
                    looking.setZ((double)z);
                    MVSPLogging.finest("Looking for sign at " + this.locationManipulation.strCoordsRaw(looking), new Object[0]);
                    BlockState signBlock = topper.getWorld().getBlockAt(looking).getState();
                    if (!(signBlock instanceof Sign)) continue;
                    MVSPLogging.finer("WOO Found one! " + this.locationManipulation.strCoordsRaw(looking), new Object[0]);
                    signs.add((Sign)signBlock);
                }
            }
        }
        return signs;
    }

    public boolean playerCanGoToDestination(Player player, DestinationInstance<?, ?> d) {
        if (d == null) {
            player.sendMessage("The Destination on this sign is Invalid!");
            return false;
        }
        return true;
    }

    static enum RedstoneTeleportType {
        ALL,
        PLAYERS,
        MONSTERS,
        ANIMALS;

    }
}

