/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.signportals.listeners;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.DestinationsProvider;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.event.MVDebugModeEvent;
import org.mvplugins.multiverse.core.event.MVDumpsDebugInfoEvent;
import org.mvplugins.multiverse.core.event.MVPlayerTouchedPortalEvent;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.signportals.MultiverseSignPortals;
import org.mvplugins.multiverse.signportals.exceptions.MoreThanOneSignFoundException;
import org.mvplugins.multiverse.signportals.exceptions.NoMultiverseSignFoundException;
import org.mvplugins.multiverse.signportals.listeners.SignPortalsListener;
import org.mvplugins.multiverse.signportals.util.MVSPLogging;
import org.mvplugins.multiverse.signportals.utils.PortalDetector;

@Service
final class MVSPVersionListener
implements SignPortalsListener {
    private final MultiverseSignPortals plugin;
    private final PortalDetector detector;
    private final DestinationsProvider destinationsProvider;

    @Inject
    MVSPVersionListener(@NotNull MultiverseSignPortals plugin, @NotNull PortalDetector detector, @NotNull DestinationsProvider destinationsProvider) {
        this.plugin = plugin;
        this.detector = detector;
        this.destinationsProvider = destinationsProvider;
    }

    @EventMethod
    public void versionEvent(MVDumpsDebugInfoEvent event) {
        event.appendDebugInfo(this.plugin.getVersionInfo());
    }

    @EventMethod
    public void portalTouchEvent(MVPlayerTouchedPortalEvent event) {
        MVSPLogging.finer("Found The TouchedPortal event.", new Object[0]);
        Player p = event.getPlayer();
        Location l = event.getBlockTouched();
        try {
            String destString = this.detector.getNotchPortalDestination(p, l);
            if (destString != null) {
                DestinationInstance d = (DestinationInstance)this.destinationsProvider.parseDestination(destString).getOrNull();
                MVSPLogging.fine(destString + " ::: " + String.valueOf(d), new Object[0]);
                if (this.detector.playerCanGoToDestination(p, d)) {
                    MVSPLogging.fine("Player could go to destination!", new Object[0]);
                    event.setCancelled(true);
                } else {
                    MVSPLogging.fine("Player could NOT go to destination!", new Object[0]);
                }
            }
        }
        catch (NoMultiverseSignFoundException e) {
            MVSPLogging.finer("Did NOT find a Multiverse Sign", new Object[0]);
        }
        catch (MoreThanOneSignFoundException e) {
            p.sendMessage(String.format("%sSorry %sbut more than 1 sign was found where the second line was [mv] or [multiverse]. Please remove one of the signs.", ChatColor.RED, ChatColor.WHITE));
        }
    }

    @EventMethod
    public void debugModeChange(MVDebugModeEvent event) {
        MVSPLogging.setDebugLevel(event.getLevel());
    }
}

