/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.signportals.listeners;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.DestinationsProvider;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.permissions.PermissionUtils;
import org.mvplugins.multiverse.core.teleportation.AsyncSafetyTeleporter;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.signportals.exceptions.MoreThanOneSignFoundException;
import org.mvplugins.multiverse.signportals.exceptions.NoMultiverseSignFoundException;
import org.mvplugins.multiverse.signportals.listeners.SignPortalsListener;
import org.mvplugins.multiverse.signportals.util.MVSPLogging;
import org.mvplugins.multiverse.signportals.utils.PortalDetector;
import org.mvplugins.multiverse.signportals.utils.SignStatus;

@Service
final class MVSPPlayerListener
implements SignPortalsListener {
    private static final String USE_PERMISSION = "multiverse.signportal.use";
    private static final String VALIDATE_PERMISSION = "multiverse.signportal.validate";
    private final DestinationsProvider destinationsProvider;
    private final AsyncSafetyTeleporter safetyTeleporter;
    private final PortalDetector pd;

    @Inject
    MVSPPlayerListener(@NotNull PortalDetector pd, @NotNull PluginManager pluginManager, @NotNull DestinationsProvider destinationsProvider, @NotNull AsyncSafetyTeleporter safetyTeleporter) {
        this.destinationsProvider = destinationsProvider;
        this.safetyTeleporter = safetyTeleporter;
        pluginManager.addPermission(new Permission(VALIDATE_PERMISSION, PermissionDefault.OP));
        pluginManager.addPermission(new Permission(USE_PERMISSION, PermissionDefault.TRUE));
        this.pd = pd;
    }

    @EventMethod
    public void playerPortal(PlayerPortalEvent event) {
        if (event.isCancelled()) {
            return;
        }
        try {
            String destString = this.pd.getNotchPortalDestination(event.getPlayer(), event.getFrom());
            if (destString != null) {
                MVSPLogging.finer("Found a Multiverse Sign", new Object[0]);
                destString = ChatColor.stripColor((String)destString);
                DestinationInstance dest = (DestinationInstance)this.destinationsProvider.parseDestination(destString).getOrNull();
                if (dest == null) {
                    MVSPLogging.warning("Could not find destination: " + destString, new Object[0]);
                    return;
                }
                Location destLocation = (Location)dest.getLocation((Entity)event.getPlayer()).getOrNull();
                if (destLocation == null) {
                    MVSPLogging.warning("Could not find Location for destination: " + destString, new Object[0]);
                    return;
                }
                event.setTo(destLocation);
            }
        }
        catch (NoMultiverseSignFoundException e) {
            MVSPLogging.finer("Did NOT find a Multiverse Sign", new Object[0]);
        }
        catch (MoreThanOneSignFoundException e) {
            event.getPlayer().sendMessage(String.format("%sSorry %sbut more than 1 sign was found where the second line was [mv] or [multiverse]. Please remove one of the signs.", ChatColor.RED, ChatColor.WHITE));
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void playerInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!(event.getClickedBlock().getState() instanceof Sign)) {
            return;
        }
        MVSPLogging.finer("Found a Sign!", new Object[0]);
        Sign s = (Sign)event.getClickedBlock().getState();
        SignStatus status = this.pd.getSignStatus(s);
        Player player = event.getPlayer();
        switch (status) {
            case SignPortal: {
                if (PermissionUtils.hasPermission((CommandSender)player, (String)USE_PERMISSION)) {
                    String destString = this.pd.processSign(s);
                    this.takePlayerToDestination(player, destString);
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have the required permission to use SignPortals (multiverse.signportal.use)");
                }
                event.setCancelled(true);
                break;
            }
            case Legacy: {
                this.pd.activateSignPortal(player, String.valueOf(ChatColor.AQUA) + "Legacy", s);
                event.setCancelled(true);
                break;
            }
            case Disabled: {
                this.pd.activateSignPortal(player, String.valueOf(ChatColor.RED) + "Disabled", s);
                event.setCancelled(true);
                break;
            }
            case NetherPortalSign: {
                event.setCancelled(true);
            }
        }
    }

    private void takePlayerToDestination(Player player, String destString) {
        if (destString != null) {
            MVSPLogging.finer("Found a SignPortal! (" + destString + ")", new Object[0]);
            DestinationInstance d = (DestinationInstance)this.destinationsProvider.parseDestination(destString).getOrNull();
            if (d == null) {
                MVSPLogging.warning("Could not find destination: " + destString, new Object[0]);
                return;
            }
            MVSPLogging.finer("Found a Destination! (" + String.valueOf(d) + ")", new Object[0]);
            if (this.pd.playerCanGoToDestination(player, d)) {
                this.safetyTeleporter.to(d).teleport((Entity)player).onSuccess(() -> player.sendMessage("Teleported " + player.getName() + " to: " + String.valueOf(ChatColor.GREEN) + String.valueOf(d))).onFailure(result -> player.sendMessage("Could not teleport " + player.getName() + " to: " + String.valueOf(ChatColor.RED) + String.valueOf(d)));
            } else {
                MVSPLogging.finer("Denied permission to go to destination!", new Object[0]);
            }
        } else {
            player.sendMessage("The Destination was not set on the sign!");
        }
    }
}

