/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.signportals.listeners;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.DestinationsProvider;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.permissions.PermissionUtils;
import org.mvplugins.multiverse.core.teleportation.AsyncSafetyTeleporter;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.signportals.MultiverseSignPortals;
import org.mvplugins.multiverse.signportals.listeners.SignPortalsListener;
import org.mvplugins.multiverse.signportals.util.MVSPLogging;
import org.mvplugins.multiverse.signportals.utils.PortalDetector;
import org.mvplugins.multiverse.signportals.utils.SignStatus;
import org.mvplugins.multiverse.signportals.utils.SignTools;

@Service
final class MVSPBlockListener
implements SignPortalsListener {
    private final String CREATE_PERM = "multiverse.signportal.create";
    private final MultiverseSignPortals plugin;
    private final PortalDetector pd;
    private final DestinationsProvider destinationsProvider;
    private final AsyncSafetyTeleporter safetyTeleporter;

    @Inject
    public MVSPBlockListener(@NotNull MultiverseSignPortals plugin, @NotNull PortalDetector pd, @NotNull PluginManager pluginManager, @NotNull DestinationsProvider destinationsProvider, @NotNull AsyncSafetyTeleporter safetyTeleporter) {
        this.plugin = plugin;
        this.pd = pd;
        this.destinationsProvider = destinationsProvider;
        this.safetyTeleporter = safetyTeleporter;
        pluginManager.addPermission(new Permission("multiverse.signportal.create", PermissionDefault.OP));
    }

    @EventMethod
    public void onSignChange(SignChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        MVSPLogging.finer("Sign changed", new Object[0]);
        if (event.getLine(1).equalsIgnoreCase("[mv]") || event.getLine(1).equalsIgnoreCase("[multiverse]")) {
            this.createMultiverseSignPortal(event);
        } else {
            this.checkForHack(event);
        }
    }

    @EventMethod
    public void redstonePower(BlockRedstoneEvent event) {
        if (event.getNewCurrent() <= 0) {
            return;
        }
        MVSPLogging.fine("Redstone power: " + event.getNewCurrent(), new Object[0]);
        boolean torch = event.getBlock().getType() == Material.REDSTONE_TORCH || event.getBlock().getType() == Material.REDSTONE_WALL_TORCH;
        Block block = this.getNearbySign(event.getBlock(), torch);
        if (block == null) {
            return;
        }
        Sign sign = (Sign)block.getState();
        SignStatus status = this.pd.getSignStatus(sign);
        if (status == SignStatus.SignPortal) {
            String destString = this.pd.processSign(sign);
            for (Entity entity : this.pd.getRedstoneTeleportEntities(sign)) {
                this.takeEntityToDestination(entity, destString);
            }
        }
    }

    private void takeEntityToDestination(Entity entity, String destString) {
        DestinationInstance d;
        if (destString == null) {
            MVSPLogging.finer("The destination was not set on the sign!", new Object[0]);
        }
        if ((d = (DestinationInstance)this.destinationsProvider.parseDestination(destString).getOrNull()) == null) {
            MVSPLogging.warning("Could not find destination: " + destString, new Object[0]);
            return;
        }
        MVSPLogging.finer("Found a Destination! (" + String.valueOf(d) + ")", new Object[0]);
        this.safetyTeleporter.to(d).by((CommandSender)Bukkit.getConsoleSender()).teleport(entity).onSuccess(() -> MVSPLogging.finer("Teleported " + String.valueOf(entity) + " to: " + String.valueOf(ChatColor.GREEN) + String.valueOf(d), new Object[0])).onFailure(error -> MVSPLogging.warning("Failed to teleport " + String.valueOf(entity) + " to: " + String.valueOf(d) + " (" + String.valueOf(error) + ")", new Object[0]));
    }

    private Block getNearbySign(Block block, boolean torch) {
        Block nearBlock = block.getRelative(BlockFace.EAST);
        if (nearBlock.getState() instanceof Sign) {
            return nearBlock;
        }
        nearBlock = block.getRelative(BlockFace.NORTH);
        if (nearBlock.getState() instanceof Sign) {
            return nearBlock;
        }
        nearBlock = block.getRelative(BlockFace.SOUTH);
        if (nearBlock.getState() instanceof Sign) {
            return nearBlock;
        }
        nearBlock = block.getRelative(BlockFace.WEST);
        if (nearBlock.getState() instanceof Sign) {
            return nearBlock;
        }
        nearBlock = block.getRelative(BlockFace.UP);
        if (nearBlock.getState() instanceof Sign) {
            return nearBlock;
        }
        if (torch && (nearBlock = nearBlock.getRelative(BlockFace.UP)).getState() instanceof Sign) {
            return nearBlock;
        }
        return null;
    }

    @EventMethod
    public void onBlockBreak(BlockBreakEvent event) {
        Sign s;
        if (event.isCancelled()) {
            return;
        }
        BlockState state = event.getBlock().getState();
        if (state instanceof Sign && (this.pd.getSignStatus(s = (Sign)state) == SignStatus.NetherPortalSign || this.pd.getSignStatus(s) == SignStatus.SignPortal) && !PermissionUtils.hasPermission((CommandSender)event.getPlayer(), (String)"multiverse.signportal.create")) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("You don't have permission to destroy a SignPortal!");
            event.getPlayer().sendMessage(String.valueOf(ChatColor.GREEN) + "multiverse.signportal.create");
        }
    }

    private void checkForHack(SignChangeEvent event) {
        if (SignTools.isMVSign(event.getLine(1), ChatColor.DARK_GREEN) || SignTools.isMVSign(event.getLine(1), ChatColor.DARK_BLUE)) {
            MVSPLogging.warning("WOAH! Player: [" + event.getPlayer().getName() + "] tried to HACK a Multiverse SignPortal into existance!", new Object[0]);
            this.warnOps("WOAH! Player: [" + event.getPlayer().getName() + "] tried to " + String.valueOf(ChatColor.RED) + "HACK" + String.valueOf(ChatColor.WHITE) + " a" + String.valueOf(ChatColor.AQUA) + " Multiverse SignPortal" + String.valueOf(ChatColor.WHITE) + " into existance!");
            event.setCancelled(true);
        }
    }

    private void createMultiverseSignPortal(SignChangeEvent event) {
        if (PermissionUtils.hasPermission((CommandSender)event.getPlayer(), (String)"multiverse.signportal.create")) {
            MVSPLogging.finer("MV SignPortal Created", new Object[0]);
            event.setLine(1, String.valueOf(ChatColor.DARK_GREEN) + event.getLine(1));
            this.checkRedstoneTeleportTargets(event);
        } else {
            MVSPLogging.finer("No Perms to create", new Object[0]);
            event.setLine(1, String.valueOf(ChatColor.DARK_RED) + event.getLine(1));
            event.getPlayer().sendMessage("You don't have permission to create a SignPortal!");
            event.getPlayer().sendMessage(String.valueOf(ChatColor.GREEN) + "multiverse.signportal.create");
        }
    }

    private void checkRedstoneTeleportTargets(SignChangeEvent event) {
        if (PortalDetector.REDSTONE_TELEPORT_PATTERN.matcher(event.getLine(0)).matches()) {
            event.setLine(0, String.valueOf(ChatColor.DARK_GREEN) + event.getLine(0));
        }
    }

    private void warnOps(String string) {
        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
            if (!p.isOp()) continue;
            p.sendMessage(string);
        }
    }
}

