/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.utils;

import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.action.ActionFailureReason;
import org.mvplugins.multiverse.portals.action.ActionHandler;

@Service
public class DisplayUtils {
    private final WorldManager worldManager;
    private final MVEconomist economist;
    private final MVCommandManager commandManager;

    @Inject
    DisplayUtils(@NotNull WorldManager worldManager, @NotNull MVEconomist economist, @NotNull MVCommandManager commandManager) {
        this.worldManager = worldManager;
        this.economist = economist;
        this.commandManager = commandManager;
    }

    public void showStaticInfo(CommandSender sender, MVPortal portal, String message) {
        MVCommandIssuer issuer = this.commandManager.getCommandIssuer((Object)sender);
        issuer.sendMessage(String.valueOf(ChatColor.AQUA) + "--- " + message + String.valueOf(ChatColor.DARK_AQUA) + portal.getName() + String.valueOf(ChatColor.AQUA) + " ---");
        String[] locParts = portal.getPortalLocation().toString().split(":");
        issuer.sendMessage(String.valueOf(ChatColor.WHITE) + "Coords: " + String.valueOf(ChatColor.GOLD) + locParts[1] + String.valueOf(ChatColor.WHITE) + " to " + String.valueOf(ChatColor.GOLD) + locParts[2] + String.valueOf(ChatColor.WHITE) + " in " + String.valueOf(ChatColor.GOLD) + portal.getWorld().getName());
        issuer.sendMessage(String.valueOf(ChatColor.WHITE) + "Configured Action Type: " + String.valueOf(ChatColor.GOLD) + portal.getActionType());
        if (portal.getAction().isEmpty()) {
            issuer.sendMessage(String.valueOf(ChatColor.WHITE) + "Configured Action: " + String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.ITALIC) + "NOT SET!");
        } else {
            issuer.sendMessage(String.valueOf(ChatColor.WHITE) + "Configured Action: " + String.valueOf(ChatColor.GOLD) + portal.getAction());
        }
        Attempt<? extends ActionHandler<?, ?>, ActionFailureReason> actionHandler = portal.getActionHandler();
        issuer.sendMessage(String.valueOf(ChatColor.WHITE) + "Check Destination Safety: " + this.formatBoolean(portal.getCheckDestinationSafety()));
        issuer.sendMessage(String.valueOf(ChatColor.WHITE) + "Teleport Non Players: " + this.formatBoolean(portal.getTeleportNonPlayers()));
        this.showPortalPriceInfo(portal, sender);
        if (sender instanceof Entity) {
            Entity entity = (Entity)sender;
            actionHandler.map(handler -> handler.actionDescription(entity)).onSuccess(actionMessage -> {
                issuer.sendMessage("");
                issuer.sendMessage(Message.of((String)(String.valueOf(ChatColor.WHITE) + "Your action when using Portal: {action}"), (MessageReplacement[])new MessageReplacement[]{MessageReplacement.replace((String)"{action}").with(actionMessage)}));
            });
        }
        actionHandler.onFailure(failure -> {
            issuer.sendMessage("");
            issuer.sendError(failure.getFailureMessage());
        });
    }

    private String formatBoolean(Boolean bool) {
        return bool != false ? String.valueOf(ChatColor.GREEN) + "true" : String.valueOf(ChatColor.RED) + "false";
    }

    @ApiStatus.AvailableSince(value="5.2")
    public String formatActionAsMVDestination(MVPortal portal) {
        MultiverseWorld destWorld;
        String destType;
        String[] split = portal.getAction().split(":", 2);
        String destination = split.length == 2 ? split[1] : "";
        String string = destType = split.length == 2 ? split[0] : "";
        if (destType.equals("w") && (destWorld = (MultiverseWorld)this.worldManager.getWorld(destination).getOrNull()) != null) {
            return "(World) " + String.valueOf(ChatColor.DARK_AQUA) + destination;
        }
        if (destType.equals("p")) {
            // empty if block
        }
        if (destType.equals("e")) {
            int z;
            int y;
            int x;
            String destinationWorld = portal.getAction().split(":")[1];
            String destPart = portal.getAction().split(":")[2];
            String[] targetParts = destPart.split(",");
            try {
                x = (int)Double.parseDouble(targetParts[0]);
                y = (int)Double.parseDouble(targetParts[1]);
                z = (int)Double.parseDouble(targetParts[2]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return String.valueOf(ChatColor.RED) + "Invalid Exact World Location!";
            }
            return "(Location) " + String.valueOf(ChatColor.DARK_AQUA) + destinationWorld + ", " + x + ", " + y + ", " + z;
        }
        if (destType.equals("i")) {
            return String.valueOf(ChatColor.RED) + "Invalid Destination!";
        }
        return String.valueOf(ChatColor.DARK_AQUA) + portal.getAction();
    }

    public void showPortalPriceInfo(MVPortal portal, CommandSender sender) {
        if (portal.getPrice() > 0.0) {
            sender.sendMessage("Price: " + String.valueOf(ChatColor.GREEN) + this.economist.formatPrice(portal.getPrice(), portal.getCurrency()));
        } else if (portal.getPrice() < 0.0) {
            sender.sendMessage("Price: " + String.valueOf(ChatColor.GREEN) + this.economist.formatPrice(-portal.getPrice(), portal.getCurrency()));
        } else {
            sender.sendMessage("Price: " + String.valueOf(ChatColor.GREEN) + "FREE!");
        }
    }
}

