/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.listeners;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.config.PortalsConfig;
import org.mvplugins.multiverse.portals.util.MVPLogging;

@Service
final class PortalListenerHelper {
    private final PortalsConfig portalsConfig;
    private final MVEconomist economist;

    @Inject
    PortalListenerHelper(@NotNull PortalsConfig portalsConfig, @NotNull MVEconomist economist) {
        this.portalsConfig = portalsConfig;
        this.economist = economist;
    }

    boolean isWithinSameBlock(Location from, Location to) {
        return from.getWorld() == to.getWorld() && from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ();
    }

    void stateSuccess(String playerName, String portalName) {
        MVPLogging.fine(String.format("MV-Portals is allowing Player '%s' to use the portal '%s'.", playerName, portalName), new Object[0]);
    }

    void stateFailure(String playerName, String portalName) {
        MVPLogging.fine(String.format("MV-Portals is DENYING Player '%s' access to use the portal '%s'.", playerName, portalName), new Object[0]);
    }

    PortalUseResult checkPlayerCanUsePortal(MVPortal portal, Player player) {
        if (this.portalsConfig.getEnforcePortalAccess() && !player.hasPermission(portal.getPermission())) {
            this.stateFailure(player.getDisplayName(), portal.getName());
            return PortalUseResult.CANNOT_USE;
        }
        double price = portal.getPrice();
        Material currency = portal.getCurrency();
        if (price == 0.0 || player.hasPermission(portal.getExempt())) {
            return PortalUseResult.FREE_USE;
        }
        if (price > 0.0 && !this.economist.isPlayerWealthyEnough(player, price, currency)) {
            player.sendMessage(this.economist.getNSFMessage(currency, "You need " + this.economist.formatPrice(price, currency) + " to enter the " + portal.getName() + " portal."));
            this.stateFailure(player.getDisplayName(), portal.getName());
            return PortalUseResult.CANNOT_USE;
        }
        return PortalUseResult.PAID_USE;
    }

    void payPortalEntryFee(MVPortal portal, Player player) {
        this.economist.payEntryFee(player, portal.getPrice(), portal.getCurrency());
    }

    static enum PortalUseResult {
        CANNOT_USE(false, false),
        FREE_USE(true, false),
        PAID_USE(true, true);

        private final boolean canUse;
        private final boolean needToPay;

        private PortalUseResult(boolean canUse, boolean needToPay) {
            this.canUse = canUse;
            this.needToPay = needToPay;
        }

        public boolean canUse() {
            return this.canUse;
        }

        public boolean needToPay() {
            return this.needToPay;
        }
    }
}

