/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.listeners;

import java.util.ArrayList;
import java.util.Date;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.PortalPlayerSession;
import org.mvplugins.multiverse.portals.enums.MoveType;
import org.mvplugins.multiverse.portals.listeners.PortalListenerHelper;
import org.mvplugins.multiverse.portals.util.MVPLogging;
import org.mvplugins.multiverse.portals.utils.PortalManager;

@Service
public final class MVPVehicleListener
implements Listener {
    private final MultiversePortals plugin;
    private final PortalManager portalManager;
    private final PortalListenerHelper helper;

    @Inject
    MVPVehicleListener(@NotNull MultiversePortals plugin, @NotNull PortalManager portalManager, @NotNull PortalListenerHelper helper) {
        this.plugin = plugin;
        this.portalManager = portalManager;
        this.helper = helper;
    }

    @EventHandler
    void vehicleMove(VehicleMoveEvent event) {
        if (this.helper.isWithinSameBlock(event.getFrom(), event.getTo())) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        ArrayList<Player> playerPassengers = new ArrayList<Player>();
        boolean hasNonPlayers = false;
        for (Entity entity : vehicle.getPassengers()) {
            if (!(entity instanceof Player)) {
                hasNonPlayers = true;
                continue;
            }
            Player player = (Player)entity;
            PortalPlayerSession ps = this.plugin.getPortalSession(player);
            ps.setStaleLocation(vehicle.getLocation(), MoveType.VEHICLE_MOVE);
            if (ps.isStaleLocation()) {
                MVPLogging.finer("Player %s is stale, not teleporting vehicle", player.getName());
                return;
            }
            playerPassengers.add(player);
        }
        MVPortal portal = this.portalManager.getPortal(vehicle.getLocation());
        if (portal == null) {
            return;
        }
        if (hasNonPlayers && !portal.getTeleportNonPlayers()) {
            MVPLogging.finer("Not teleporting vehicle using %s because it has non-player passengers", portal.getName());
            return;
        }
        if (!portal.isFrameValid(vehicle.getLocation())) {
            MVPLogging.finer("Not teleporting vehicle using %s as the frame is made of an incorrect material.", portal.getName());
            return;
        }
        for (Player player : playerPassengers) {
            PortalListenerHelper.PortalUseResult portalUseResult = this.helper.checkPlayerCanUsePortal(portal, player);
            if (!portalUseResult.canUse()) {
                MVPLogging.finer("Player %s is not allowed to use portal %s, removing them from the vehicle.", player.getName(), portal.getName());
                vehicle.removePassenger((Entity)player);
            }
            if (!portalUseResult.needToPay()) continue;
            this.helper.payPortalEntryFee(portal, player);
        }
        MVPLogging.fine("[VehicleMoveEvent] Portal action for vehicle: " + String.valueOf(vehicle), new Object[0]);
        this.helper.stateSuccess(vehicle.getName(), portal.getName());
        portal.runActionFor((Entity)vehicle).onSuccess(() -> playerPassengers.forEach(player -> this.plugin.getPortalSession((Player)player).setTeleportTime(new Date())));
    }
}

