/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.listeners;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerPortalEvent;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.teleportation.BlockSafety;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.PortalPlayerSession;
import org.mvplugins.multiverse.portals.config.PortalsConfig;
import org.mvplugins.multiverse.portals.enums.MoveType;
import org.mvplugins.multiverse.portals.event.MVPortalEvent;
import org.mvplugins.multiverse.portals.listeners.PortalListenerHelper;
import org.mvplugins.multiverse.portals.listeners.PortalsListener;
import org.mvplugins.multiverse.portals.util.MVPLogging;
import org.mvplugins.multiverse.portals.utils.PortalManager;

@Service
final class MVPPlayerPortalListener
implements PortalsListener {
    private final PortalManager portalManager;
    private final PortalsConfig portalsConfig;
    private final BlockSafety blockSafety;
    private final MultiversePortals plugin;
    private final PortalListenerHelper helper;

    @Inject
    MVPPlayerPortalListener(@NotNull PortalManager portalManager, @NotNull PortalsConfig portalsConfig, @NotNull BlockSafety blockSafety, @NotNull MultiversePortals plugin, @NotNull PortalListenerHelper helper) {
        this.portalManager = portalManager;
        this.portalsConfig = portalsConfig;
        this.blockSafety = blockSafety;
        this.plugin = plugin;
        this.helper = helper;
    }

    @EventHandler(ignoreCancelled=true)
    void playerPortal(PlayerPortalEvent event) {
        MVPLogging.finer("onPlayerPortal called!", new Object[0]);
        Player player = event.getPlayer();
        Location playerPortalLoc = player.getLocation();
        MVPortal portal = this.portalManager.getPortal(player, playerPortalLoc, false);
        if (portal == null && (playerPortalLoc = this.blockSafety.findPortalBlockNextTo(event.getFrom())) != null) {
            MVPLogging.finer("Player was outside of portal, The location has been successfully translated.", new Object[0]);
            portal = this.portalManager.getPortal(player, playerPortalLoc, false);
        }
        if (portal == null) {
            return;
        }
        MVPLogging.finer("There was a portal found!", new Object[0]);
        if (!this.portalsConfig.getPortalsDefaultToNether()) {
            event.setCancelled(true);
        }
        if (!portal.isFrameValid(playerPortalLoc)) {
            player.sendMessage("This portal's frame is made of an " + String.valueOf(ChatColor.RED) + "incorrect material." + String.valueOf(ChatColor.RED) + " You should exit it now.");
            event.setCancelled(true);
            return;
        }
        PortalPlayerSession ps = this.plugin.getPortalSession(player);
        ps.setStaleLocation(playerPortalLoc, MoveType.PLAYER_MOVE);
        if (ps.showDebugInfo()) {
            event.setCancelled(true);
            return;
        }
        if (ps.checkAndSendCooldownMessage()) {
            MVPLogging.fine("Player denied teleportation due to cooldown.", new Object[0]);
            return;
        }
        PortalListenerHelper.PortalUseResult portalUseResult = this.helper.checkPlayerCanUsePortal(portal, player);
        if (!portalUseResult.canUse()) {
            return;
        }
        MVPortalEvent portalEvent = new MVPortalEvent(portal.getDestination(), player, portal);
        this.plugin.getServer().getPluginManager().callEvent((Event)portalEvent);
        if (portalEvent.isCancelled()) {
            MVPLogging.fine("Someone cancelled the MVPlayerPortal Event!", new Object[0]);
            return;
        }
        if (portalUseResult.needToPay()) {
            this.helper.payPortalEntryFee(portal, player);
        }
        MVPLogging.fine("[PlayerPortalEvent] Portal action for player: " + String.valueOf(player), new Object[0]);
        this.helper.stateSuccess(player.getDisplayName(), portal.getName());
        portal.runActionFor((Entity)player).onSuccess(() -> event.setCancelled(true));
    }
}

