/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.listeners;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.PortalPlayerSession;
import org.mvplugins.multiverse.portals.config.PortalsConfig;
import org.mvplugins.multiverse.portals.enums.MoveType;
import org.mvplugins.multiverse.portals.event.MVPortalEvent;
import org.mvplugins.multiverse.portals.listeners.PortalListenerHelper;
import org.mvplugins.multiverse.portals.util.MVPLogging;

@Service
public final class MVPPlayerMoveListener
implements Listener {
    private final MultiversePortals plugin;
    private final PortalsConfig portalsConfig;
    private final PortalListenerHelper helper;

    @Inject
    MVPPlayerMoveListener(@NotNull MultiversePortals plugin, @NotNull PortalsConfig portalsConfig, @NotNull PortalListenerHelper helper) {
        this.plugin = plugin;
        this.portalsConfig = portalsConfig;
        this.helper = helper;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    void playerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Location loc = player.getLocation();
        PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
        ps.setStaleLocation(loc, MoveType.PLAYER_MOVE);
        if (ps.isStaleLocation()) {
            return;
        }
        MVPortal portal = ps.getStandingInPortal();
        if (portal == null || this.portalsConfig.getNetherAnimation() && !portal.isLegacyPortal() || !ps.doTeleportPlayer(MoveType.PLAYER_MOVE) || ps.showDebugInfo()) {
            return;
        }
        player.setFallDistance(0.0f);
        if (!portal.isFrameValid(loc)) {
            player.sendMessage("This portal's frame is made of an " + String.valueOf(ChatColor.RED) + "incorrect material. You should exit it now.");
            return;
        }
        if (ps.checkAndSendCooldownMessage()) {
            return;
        }
        PortalListenerHelper.PortalUseResult portalUseResult = this.helper.checkPlayerCanUsePortal(portal, player);
        if (!portalUseResult.canUse()) {
            return;
        }
        MVPortalEvent portalEvent = new MVPortalEvent(portal.getDestination(), event.getPlayer(), portal);
        this.plugin.getServer().getPluginManager().callEvent((Event)portalEvent);
        if (portalEvent.isCancelled()) {
            return;
        }
        if (portalUseResult.needToPay()) {
            this.helper.payPortalEntryFee(portal, player);
        }
        MVPLogging.fine("[PlayerMoveEvent] Portal action for player: " + String.valueOf(player), new Object[0]);
        portal.runActionFor((Entity)player);
    }
}

