/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.listeners;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.PortalPlayerSession;
import org.mvplugins.multiverse.portals.WorldEditConnection;
import org.mvplugins.multiverse.portals.config.PortalsConfig;
import org.mvplugins.multiverse.portals.listeners.PortalsListener;
import org.mvplugins.multiverse.portals.util.MVPLogging;
import org.mvplugins.multiverse.portals.utils.PortalFiller;
import org.mvplugins.multiverse.portals.utils.PortalManager;

@Service
final class MVPPlayerListener
implements PortalsListener {
    private final MultiversePortals plugin;
    private final PortalsConfig portalsConfig;
    private final PortalFiller filler;
    private final PortalManager portalManager;
    private final LocationManipulation locationManipulation;
    private final WorldManager worldManager;

    @Inject
    MVPPlayerListener(@NotNull MultiversePortals plugin, @NotNull PortalsConfig portalsConfig, @NotNull PortalManager portalManager, @NotNull PortalFiller filler, @NotNull LocationManipulation locationManipulation, @NotNull WorldManager worldManager) {
        this.plugin = plugin;
        this.portalsConfig = portalsConfig;
        this.portalManager = portalManager;
        this.filler = filler;
        this.locationManipulation = locationManipulation;
        this.worldManager = worldManager;
    }

    @EventHandler
    void playerQuit(PlayerQuitEvent event) {
        this.plugin.destroyPortalSession(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void playerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            MVPLogging.fine("The PlayerTeleportEvent was already cancelled. Doing nothing.", new Object[0]);
            return;
        }
        PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
        ps.playerDidTeleport(event.getTo());
    }

    @EventHandler(priority=EventPriority.LOW)
    void playerBucketFill(PlayerBucketFillEvent event) {
        if (event.isCancelled()) {
            MVPLogging.fine("The PlayerBucketFillEvent was already cancelled. Doing nothing.", new Object[0]);
            return;
        }
        MVPLogging.finer("Fill: ", new Object[0]);
        MVPLogging.finer("Block Clicked: " + String.valueOf(event.getBlockClicked()) + ":" + String.valueOf(event.getBlockClicked().getType()), new Object[0]);
        PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
        MVPortal portal = this.portalManager.getPortal(event.getPlayer(), event.getBlockClicked().getLocation());
        if (portal == null) {
            return;
        }
        if (ps.isDebugModeOn()) {
            ps.showDebugInfo(portal);
            event.setCancelled(true);
            return;
        }
        Material fillMaterial = Material.AIR;
        MVPLogging.finer("Fill Material: " + String.valueOf(fillMaterial), new Object[0]);
        this.filler.fillRegion(portal.getPortalLocation().getRegion(), event.getBlockClicked().getLocation(), fillMaterial, event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOW)
    void playerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (event.isCancelled()) {
            MVPLogging.fine("The PlayerBucketEmptyEvent was already cancelled. Doing nothing.", new Object[0]);
            return;
        }
        if (!this.portalsConfig.getBucketFilling()) {
            MVPLogging.fine("The bucket filling functionality has been disabled in config, doing nothing", new Object[0]);
            return;
        }
        Location translatedLocation = this.getTranslatedLocation(event.getBlockClicked(), event.getBlockFace());
        MVPLogging.finer("Fill: ", new Object[0]);
        MVPLogging.finer("Block Clicked: " + String.valueOf(event.getBlockClicked()) + ":" + String.valueOf(event.getBlockClicked().getType()), new Object[0]);
        MVPLogging.finer("Translated Block: " + String.valueOf(event.getPlayer().getWorld().getBlockAt(translatedLocation)) + ":" + String.valueOf(event.getPlayer().getWorld().getBlockAt(translatedLocation).getType()), new Object[0]);
        PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
        MVPortal portal = this.portalManager.getPortal(event.getPlayer(), translatedLocation);
        if (portal == null) {
            return;
        }
        if (ps.isDebugModeOn()) {
            ps.showDebugInfo(portal);
            event.setCancelled(true);
            return;
        }
        if (!portal.playerCanFillPortal(event.getPlayer())) {
            event.setCancelled(true);
            return;
        }
        Material fillMaterial = Material.WATER;
        if (event.getBucket().equals((Object)Material.LAVA_BUCKET)) {
            fillMaterial = Material.LAVA;
        }
        MVPLogging.finer("Fill Material: " + String.valueOf(fillMaterial), new Object[0]);
        this.filler.fillRegion(portal.getPortalLocation().getRegion(), translatedLocation, fillMaterial, event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOW)
    void playerInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            MVPLogging.fine("The PlayerInteractEvent was already cancelled. Doing nothing.", new Object[0]);
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getMaterial() == Material.FLINT_AND_STEEL) {
            this.lightPortalWithFlintAndSteel(event);
            return;
        }
        Material itemType = this.portalsConfig.getWandMaterial();
        WorldEditConnection worldEdit = this.plugin.getWorldEditConnection();
        if (worldEdit != null && worldEdit.isConnected() || event.getPlayer().getInventory().getItemInMainHand().getType() != itemType || !event.getPlayer().hasPermission("multiverse.portal.create") || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
            LoadedMultiverseWorld world = (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(event.getPlayer().getWorld().getName()).getOrNull();
            event.setCancelled(this.plugin.getPortalSession(event.getPlayer()).setLeftClickSelection(event.getClickedBlock().getLocation().toVector(), world));
        } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            LoadedMultiverseWorld world = (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(event.getPlayer().getWorld().getName()).getOrNull();
            event.setCancelled(this.plugin.getPortalSession(event.getPlayer()).setRightClickSelection(event.getClickedBlock().getLocation().toVector(), world));
        }
    }

    private void lightPortalWithFlintAndSteel(PlayerInteractEvent event) {
        MVPLogging.finer("Player is lighting block: " + this.locationManipulation.strCoordsRaw(event.getClickedBlock().getLocation()), new Object[0]);
        PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
        Location translatedLocation = this.getTranslatedLocation(event.getClickedBlock(), event.getBlockFace());
        if (!this.portalManager.isPortal(translatedLocation)) {
            return;
        }
        MVPortal portal = this.portalManager.getPortal(event.getPlayer(), translatedLocation);
        if (event.getItem() == null) {
            return;
        }
        if (!event.getPlayer().hasPermission("multiverse.portal.create")) {
            return;
        }
        Material inHand = event.getItem().getType();
        if (portal == null) {
            return;
        }
        if (!portal.isFrameValid(translatedLocation)) {
            return;
        }
        MVPLogging.finer("Right Clicked: ", new Object[0]);
        MVPLogging.finer("Block Clicked: " + String.valueOf(event.getClickedBlock()) + ":" + String.valueOf(event.getClickedBlock().getType()), new Object[0]);
        MVPLogging.finer("Translated Block: " + String.valueOf(event.getPlayer().getWorld().getBlockAt(translatedLocation)) + ":" + String.valueOf(event.getPlayer().getWorld().getBlockAt(translatedLocation).getType()), new Object[0]);
        MVPLogging.finer("In Hand: " + String.valueOf(inHand), new Object[0]);
        if (ps.isDebugModeOn()) {
            ps.showDebugInfo(portal);
            event.setCancelled(true);
            return;
        }
        Material fillMaterial = Material.NETHER_PORTAL;
        if (translatedLocation.getWorld().getBlockAt(translatedLocation).getType() == Material.NETHER_PORTAL) {
            fillMaterial = Material.AIR;
        }
        MVPLogging.finer("Fill Material: " + String.valueOf(fillMaterial), new Object[0]);
        event.setCancelled(this.filler.fillRegion(portal.getPortalLocation().getRegion(), translatedLocation, fillMaterial, event.getPlayer()));
    }

    private Location getTranslatedLocation(Block clickedBlock, BlockFace face) {
        Location clickedLoc = clickedBlock.getLocation();
        Location newLoc = new Location(clickedBlock.getWorld(), (double)(face.getModX() + clickedLoc.getBlockX()), (double)(face.getModY() + clickedLoc.getBlockY()), (double)(face.getModZ() + clickedLoc.getBlockZ()));
        MVPLogging.finest("Clicked Block: " + String.valueOf(clickedBlock.getLocation()), new Object[0]);
        MVPLogging.finest("Translated Block: " + String.valueOf(newLoc), new Object[0]);
        return newLoc;
    }
}

