/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.listeners;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEvent;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.teleportation.BlockSafety;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.config.PortalsConfig;
import org.mvplugins.multiverse.portals.listeners.PortalListenerHelper;
import org.mvplugins.multiverse.portals.util.MVPLogging;
import org.mvplugins.multiverse.portals.utils.PortalManager;

@Service
public final class MVPEntityPortalListener
implements Listener {
    private final PortalManager portalManager;
    private final PortalsConfig portalsConfig;
    private final BlockSafety blockSafety;
    private final PortalListenerHelper helper;

    @Inject
    MVPEntityPortalListener(@NotNull PortalManager portalManager, @NotNull PortalsConfig portalsConfig, @NotNull BlockSafety blockSafety, @NotNull PortalListenerHelper helper) {
        this.portalManager = portalManager;
        this.portalsConfig = portalsConfig;
        this.blockSafety = blockSafety;
        this.helper = helper;
    }

    @EventHandler(ignoreCancelled=true)
    void entityPortal(EntityPortalEvent event) {
        Location translatedLoc;
        Entity entity = event.getEntity();
        Location location = entity.getLocation();
        MVPortal portal = this.portalManager.getPortal(location);
        if (portal == null && (translatedLoc = this.blockSafety.findPortalBlockNextTo(event.getFrom())) != null) {
            MVPLogging.finer("Entity was outside of portal, The location has been successfully translated.", new Object[0]);
            portal = this.portalManager.getPortal(translatedLoc);
        }
        if (portal == null) {
            return;
        }
        if (!portal.getTeleportNonPlayers()) {
            if (!this.portalsConfig.getPortalsDefaultToNether()) {
                event.setCancelled(true);
            }
            return;
        }
        MVPLogging.fine("[EntityPortalEvent] Portal action for entity: " + String.valueOf(entity), new Object[0]);
        this.helper.stateSuccess(entity.getName(), portal.getName());
        portal.runActionFor(entity).onSuccess(() -> event.setCancelled(true));
    }
}

