/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.listeners;

import java.io.File;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.event.MVConfigReloadEvent;
import org.mvplugins.multiverse.core.event.MVDebugModeEvent;
import org.mvplugins.multiverse.core.event.MVDumpsDebugInfoEvent;
import org.mvplugins.multiverse.core.event.MVPlayerTouchedPortalEvent;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.config.PortalsConfig;
import org.mvplugins.multiverse.portals.listeners.PortalsListener;
import org.mvplugins.multiverse.portals.util.MVPLogging;
import org.mvplugins.multiverse.portals.utils.PortalManager;

@Service
final class MVPCoreListener
implements PortalsListener {
    private final MultiversePortals plugin;
    private final PortalsConfig config;
    private final PortalManager portalManager;

    @Inject
    MVPCoreListener(@NotNull MultiversePortals plugin, @NotNull PortalManager portalManager, @NotNull PortalsConfig config) {
        this.plugin = plugin;
        this.portalManager = portalManager;
        this.config = config;
    }

    @EventHandler
    public void dumpsDebugInfoRequest(MVDumpsDebugInfoEvent event) {
        event.appendDebugInfo(this.plugin.getVersionInfo());
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        File portalsFile = new File(this.plugin.getDataFolder(), "portals.yml");
        event.putDetailedDebugInfo("multiverse-portals/config.yml", configFile);
        event.putDetailedDebugInfo("multiverse-portals/portals.yml", portalsFile);
    }

    @EventHandler
    public void configReload(MVConfigReloadEvent event) {
        this.plugin.reloadConfigs();
        event.addConfig("Multiverse-Portals - portals.yml");
        event.addConfig("Multiverse-Portals - config.yml");
    }

    @EventHandler
    public void debugModeChange(MVDebugModeEvent event) {
        MVPLogging.setDebugLevel(event.getLevel());
    }

    @EventHandler
    public void portalTouchEvent(MVPlayerTouchedPortalEvent event) {
        MVPLogging.finer("Found The TouchedPortal event.", new Object[0]);
        Location l = event.getBlockTouched();
        if (!event.canUseThisPortal() || !this.portalManager.isPortal(l)) {
            return;
        }
        if (this.plugin.getPortalSession(event.getPlayer()).isDebugModeOn()) {
            event.setCancelled(true);
            return;
        }
        MVPortal p = this.portalManager.getPortal(event.getPlayer(), l);
        if (p == null) {
            MVPLogging.finer(String.format("'%s' was DENIED access to this portal event.", event.getPlayer().getName()), new Object[0]);
            event.setCanUseThisPortal(false);
        } else if (p.getActionHandler().isFailure()) {
            if (this.config.getPortalsDefaultToNether()) {
                MVPLogging.finer("Allowing MVPortal to act as nether portal.", new Object[0]);
                return;
            }
            event.getPlayer().sendMessage("This Multiverse Portal does not have a valid destination!");
            event.setCanUseThisPortal(false);
        }
    }
}

