/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.listeners;

import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.config.PortalsConfig;
import org.mvplugins.multiverse.portals.listeners.PortalsListener;
import org.mvplugins.multiverse.portals.utils.PortalManager;

@Service
final class MVPBlockListener
implements PortalsListener {
    private final PortalManager portalManager;
    private final PortalsConfig portalsConfig;

    @Inject
    MVPBlockListener(@NotNull PortalManager portalManager, @NotNull PortalsConfig portalsConfig) {
        this.portalManager = portalManager;
        this.portalsConfig = portalsConfig;
    }

    @EventHandler(ignoreCancelled=true)
    void blockPhysics(BlockPhysicsEvent event) {
        if ((event.getChangedType() == Material.NETHER_PORTAL || event.getBlock().getType() == Material.NETHER_PORTAL) && this.portalManager.isPortal(event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    void blockFromTo(BlockFromToEvent event) {
        if (event.getBlock() == null || event.getToBlock() == null) {
            return;
        }
        if (this.portalManager.isPortal(event.getToBlock().getLocation())) {
            event.setCancelled(true);
            return;
        }
        if (this.portalManager.isPortal(event.getBlock().getLocation()) && this.portalsConfig.getBucketFilling()) {
            event.setCancelled(true);
        }
    }
}

