/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.event;

import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.enums.PortalType;

public class MVPortalEvent
extends Event
implements Cancellable {
    private Player teleportee;
    private MVPortal sendingPortal;
    private DestinationInstance<?, ?> destination;
    private boolean isCancelled;
    private static final HandlerList HANDLERS = new HandlerList();

    public MVPortalEvent(DestinationInstance<?, ?> destination, Player teleportee, MVPortal sendingPortal) {
        this.teleportee = teleportee;
        this.destination = destination;
        this.sendingPortal = sendingPortal;
    }

    public MVPortalEvent(DestinationInstance<?, ?> destination, Player teleportee) {
        this(destination, teleportee, null);
    }

    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public Player getTeleportee() {
        return this.teleportee;
    }

    public Location getFrom() {
        return this.teleportee.getLocation();
    }

    @Deprecated(since="5.2", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public DestinationInstance<?, ?> getDestination() {
        return this.destination;
    }

    @Deprecated
    public PortalType getPortalType() throws IllegalStateException {
        return this.getSendingPortal().getPortalType();
    }

    public MVPortal getSendingPortal() {
        return this.sendingPortal;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.isCancelled = cancelled;
    }
}

