/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.commands;

import org.bukkit.ChatColor;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.config.handle.StringPropertyHandle;
import org.mvplugins.multiverse.core.locale.message.LocalizableMessage;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.ConsumesRest;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.commands.PortalsCommand;
import org.mvplugins.multiverse.portals.util.MVPLogging;

@Service
class ModifyCommand
extends PortalsCommand {
    private final MultiversePortals plugin;
    private final WorldManager worldManager;

    @Inject
    ModifyCommand(@NotNull MultiversePortals plugin, @NotNull WorldManager worldManager) {
        this.plugin = plugin;
        this.worldManager = worldManager;
    }

    @Subcommand(value="modify")
    @CommandPermission(value="multiverse.portal.modify")
    @CommandCompletion(value="@mvportals @portalpropertynames @portalpropertyvalues")
    @Syntax(value="[portal] <property> <value>")
    @Description(value="Allows you to modify all values that can be set.")
    public void onModifyCommand(MVCommandIssuer issuer, @Flags(value="resolve=issuerAware") @Syntax(value="[portal]") @Description(value="The portal to modify.") MVPortal portal, @Syntax(value="<property>") @Description(value="The property to modify.") String property, @ConsumesRest @Syntax(value="<value>") @Description(value="The value to set.") String value) {
        if ((property.equalsIgnoreCase("dest") || property.equalsIgnoreCase("destination")) && value.equalsIgnoreCase("here") && !this.worldManager.isWorld("here")) {
            MVPLogging.warning("Using 'here' as a destination is deprecated and will be removed in a future version. Use 'e:@here' instead.", new Object[0]);
            issuer.sendError("Using 'here' as a destination is deprecated and will be removed in a future version. Use 'e:@here' instead.", new MessageReplacement[0]);
            value = "e:@here";
        }
        String finalValue = value;
        StringPropertyHandle stringPropertyHandle = portal.getStringPropertyHandle();
        stringPropertyHandle.setPropertyString(issuer.getIssuer(), property, value).onSuccess(ignore -> {
            if (!this.plugin.savePortalsConfig()) {
                issuer.sendError("Could not save portals configuration file!", new MessageReplacement[0]);
                return;
            }
            issuer.sendMessage(String.valueOf(ChatColor.GREEN) + "Property " + String.valueOf(ChatColor.AQUA) + property + String.valueOf(ChatColor.GREEN) + " of Portal " + String.valueOf(ChatColor.YELLOW) + portal.getName() + String.valueOf(ChatColor.GREEN) + " was set to " + String.valueOf(ChatColor.AQUA) + String.valueOf(stringPropertyHandle.getProperty(property).getOrNull()));
            if (property.equalsIgnoreCase("action-type")) {
                issuer.sendError("Please note that changing the action type &edoes NOT modify &cthe action itself. You need to modify the action property as well to ensure the portal works as expected.", new MessageReplacement[0]);
            }
        }).onFailure(failure -> {
            issuer.sendError("Property " + String.valueOf(ChatColor.AQUA) + property + String.valueOf(ChatColor.RED) + " of Portal " + String.valueOf(ChatColor.YELLOW) + portal.getName() + String.valueOf(ChatColor.RED) + " was NOT set to " + String.valueOf(ChatColor.AQUA) + finalValue, new MessageReplacement[0]);
            if (failure instanceof LocalizableMessage) {
                LocalizableMessage localizableMessage = (LocalizableMessage)failure;
                issuer.sendError(localizableMessage.getLocalizableMessage());
            } else {
                issuer.sendError(failure.getMessage(), new MessageReplacement[0]);
            }
        });
    }

    @Service
    private static final class LegacyAlias
    extends ModifyCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(MultiversePortals plugin, WorldManager worldManager) {
            super(plugin, worldManager);
        }

        @Override
        @CommandAlias(value="mvpmodify|mvpm")
        public void onModifyCommand(MVCommandIssuer issuer, MVPortal portal, String property, String value) {
            super.onModifyCommand(issuer, portal, property, value);
        }
    }
}

