/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Default;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.commands.PortalsCommand;
import org.mvplugins.multiverse.portals.utils.DisplayUtils;
import org.mvplugins.multiverse.portals.utils.PortalManager;

@Service
class ListCommand
extends PortalsCommand {
    private static final int ITEMS_PER_PAGE = 9;
    private final PortalManager portalManager;
    private final WorldManager worldManager;
    private final DisplayUtils displayUtils;

    @Inject
    ListCommand(@NotNull PortalManager portalManager, @NotNull WorldManager worldManager, @NotNull DisplayUtils displayUtils) {
        this.portalManager = portalManager;
        this.worldManager = worldManager;
        this.displayUtils = displayUtils;
    }

    @Subcommand(value="list")
    @CommandPermission(value="multiverse.portal.list")
    @CommandCompletion(value="@empty @empty")
    @Syntax(value="[filter/world] [page]")
    @Description(value="Displays a listing of all portals that you can enter.")
    void onListCommand(@NotNull CommandSender sender, @Optional @Syntax(value="[filter/world]") @Description(value="Filter by name or world") String filterOrWorld, @Default(value="1") @Syntax(value="[page]") @Description(value="Page to display") int page) {
        ArrayList<String> portals;
        String filter = filterOrWorld;
        MultiverseWorld world = (MultiverseWorld)this.worldManager.getLoadedWorld(filter).getOrNull();
        if (world != null) {
            filter = null;
        }
        if ((portals = new ArrayList<String>(this.getPortals(sender, world, filter, page))).isEmpty() && filter == null) {
            page = (int)Math.ceil(1.0f * (float)this.getPortals(sender, world, filter).size() / 9.0f);
            portals.addAll(this.getPortals(sender, world, filter, page));
        }
        String titleString = String.valueOf(ChatColor.AQUA) + String.valueOf(this.getPortals(sender, world, filter).size()) + " Portals";
        if (world != null) {
            titleString = titleString + " in " + String.valueOf(ChatColor.YELLOW) + world.getAlias();
        }
        if (filter != null) {
            titleString = titleString + String.valueOf(ChatColor.GOLD) + " [" + filter + "]";
        }
        titleString = titleString + String.valueOf(ChatColor.GOLD) + " - Page " + page + "/" + (int)Math.ceil(1.0f * (float)this.getPortals(sender, world, filter).size() / 9.0f);
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "--- " + titleString + String.valueOf(ChatColor.AQUA) + " ---");
        for (String portal : portals) {
            sender.sendMessage(portal);
        }
    }

    private List<String> getPortals(CommandSender sender, MultiverseWorld world, String filter) {
        ArrayList<String> portals = new ArrayList<String>();
        if (filter == null) {
            filter = "";
        }
        for (MVPortal portal : world == null ? this.portalManager.getPortals(sender) : this.portalManager.getPortals(sender, world)) {
            String destination = this.displayUtils.formatActionAsMVDestination(portal);
            if (!portal.getName().toLowerCase().contains(filter.toLowerCase()) && !destination.toLowerCase().contains(filter.toLowerCase())) continue;
            portals.add(String.valueOf(ChatColor.YELLOW) + portal.getName() + String.valueOf(ChatColor.AQUA) + " -> " + String.valueOf(ChatColor.GOLD) + destination);
        }
        Collections.sort(portals);
        return portals;
    }

    private List<String> getPortals(CommandSender sender, MultiverseWorld world, String filter, int page) {
        ArrayList<String> portals = new ArrayList<String>();
        for (int i = 0; i < this.getPortals(sender, world, filter).size(); ++i) {
            if (i < page * 9 - 9 || i > page * 9 - 1) continue;
            portals.add(this.getPortals(sender, world, filter).get(i));
        }
        return portals;
    }

    @Service
    private static final class LegacyAlias
    extends ListCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(PortalManager portalManager, WorldManager worldManager, DisplayUtils displayUtils) {
            super(portalManager, worldManager, displayUtils);
        }

        @Override
        @CommandAlias(value="mvplist|mvpl")
        void onListCommand(CommandSender sender, String filterOrWorld, int page) {
            super.onListCommand(sender, filterOrWorld, page);
        }
    }
}

