/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.commands;

import org.bukkit.entity.Player;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.commands.PortalsCommand;
import org.mvplugins.multiverse.portals.utils.DisplayUtils;

@Service
class InfoCommand
extends PortalsCommand {
    private final MultiversePortals plugin;
    private final DisplayUtils displayUtils;

    @Inject
    InfoCommand(@NotNull MultiversePortals plugin, @NotNull DisplayUtils displayUtils) {
        this.plugin = plugin;
        this.displayUtils = displayUtils;
    }

    @Subcommand(value="info")
    @CommandPermission(value="multiverse.portal.info")
    @CommandCompletion(value="@mvportals")
    @Syntax(value="[portal]")
    @Description(value="Displays information about a portal.")
    void onInfoCommand(@NotNull MVCommandIssuer issuer, @Flags(value="resolve=issuerAware") @Syntax(value="[portal]") @Description(value="The portal to show info") MVPortal portal) {
        if (issuer.isPlayer()) {
            Player p = issuer.getPlayer();
            this.plugin.getPortalSession(p).showDebugInfo(portal);
        } else {
            this.displayUtils.showStaticInfo(issuer.getIssuer(), portal, "Portal Info: ");
        }
    }

    @Service
    private static final class LegacyAlias
    extends InfoCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(MultiversePortals plugin, DisplayUtils displayUtils) {
            super(plugin, displayUtils);
        }

        @Override
        @CommandAlias(value="mvpinfo|mvpi")
        void onInfoCommand(MVCommandIssuer issuer, MVPortal portal) {
            super.onInfoCommand(issuer, portal);
        }
    }
}

