/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.commands;

import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.commands.PortalsCommand;
import org.mvplugins.multiverse.portals.config.PortalsConfig;

@Service
class ConfigCommand
extends PortalsCommand {
    private final PortalsConfig portalsConfig;

    @Inject
    ConfigCommand(@NotNull PortalsConfig portalsConfig) {
        this.portalsConfig = portalsConfig;
    }

    @Subcommand(value="config")
    @CommandPermission(value="multiverse.portal.config")
    @CommandCompletion(value="@portalconfigproperties @portalconfigvalues")
    @Syntax(value="<property> [value]")
    @Description(value="Allows you to set Global MV Portals Variables.")
    void onConfigCommand(@NotNull MVCommandIssuer issuer, @Optional @Syntax(value="<property>") @Description(value="The property to set or get info of.") String property, @Optional @Syntax(value="[value]") @Description(value="The value to set.") String value) {
        if (value == null) {
            this.showConfigValue(issuer, property);
            return;
        }
        this.updateConfigValue(issuer, property, value);
    }

    private void showConfigValue(MVCommandIssuer issuer, String name) {
        this.portalsConfig.getStringPropertyHandle().getProperty(name).onSuccess(value -> issuer.sendMessage((MessageKeyProvider)MVCorei18n.CONFIG_SHOW_SUCCESS, new MessageReplacement[]{MessageReplacement.Replace.NAME.with((Object)name), MessageReplacement.Replace.VALUE.with(value)})).onFailure(e -> issuer.sendMessage((MessageKeyProvider)MVCorei18n.CONFIG_SHOW_ERROR, new MessageReplacement[]{MessageReplacement.Replace.NAME.with((Object)name), MessageReplacement.Replace.ERROR.with(e)}));
    }

    private void updateConfigValue(MVCommandIssuer issuer, String name, String value) {
        this.portalsConfig.getStringPropertyHandle().setPropertyString(issuer.getIssuer(), name, value).onSuccess(ignore -> {
            this.portalsConfig.save();
            issuer.sendMessage((MessageKeyProvider)MVCorei18n.CONFIG_SET_SUCCESS, new MessageReplacement[]{MessageReplacement.Replace.NAME.with((Object)name), MessageReplacement.Replace.VALUE.with((Object)value)});
        }).onFailure(e -> issuer.sendMessage((MessageKeyProvider)MVCorei18n.CONFIG_SET_ERROR, new MessageReplacement[]{MessageReplacement.Replace.NAME.with((Object)name), MessageReplacement.Replace.VALUE.with((Object)value), MessageReplacement.Replace.ERROR.with(e)}));
    }

    @Service
    private static final class LegacyAlias
    extends ConfigCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(PortalsConfig portalsConfig) {
            super(portalsConfig);
        }

        @Override
        @CommandAlias(value="mvpconfig|mvpconf")
        @Subcommand(value="config|conf")
        void onConfigCommand(MVCommandIssuer issuer, String property, String value) {
            super.onConfigCommand(issuer, property, value);
        }
    }
}

