/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.action.types;

import java.util.Collection;
import org.bukkit.command.CommandSender;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.action.ActionFailureReason;
import org.mvplugins.multiverse.portals.action.ActionHandlerType;
import org.mvplugins.multiverse.portals.action.types.BungeeServerList;
import org.mvplugins.multiverse.portals.action.types.ServerActionHandler;

@Service
final class ServerActionHandlerType
extends ActionHandlerType<ServerActionHandlerType, ServerActionHandler> {
    private final MultiversePortals plugin;
    private final BungeeServerList bungeeServerList;

    @Inject
    ServerActionHandlerType(@NotNull MultiversePortals plugin, @NotNull BungeeServerList bungeeServerList) {
        super("server");
        this.plugin = plugin;
        this.bungeeServerList = bungeeServerList;
    }

    @Override
    @NotNull
    public Attempt<ServerActionHandler, ActionFailureReason> parseHandler(@NotNull CommandSender sender, @NotNull String action) {
        if (action.isEmpty()) {
            return Attempt.failure((FailureReason)ActionFailureReason.INSTANCE, (Message)Message.of((String)"Please specific a server name as the portal's action.", (MessageReplacement[])new MessageReplacement[0]));
        }
        return Attempt.success((Object)new ServerActionHandler(this, this.plugin, action));
    }

    @Override
    @NotNull
    public Collection<String> suggestActions(@NotNull CommandSender sender, @NotNull String input) {
        return this.bungeeServerList.getServerNames();
    }
}

