/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.action.types;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.action.ActionFailureReason;
import org.mvplugins.multiverse.portals.action.ActionHandler;
import org.mvplugins.multiverse.portals.action.types.ServerActionHandlerType;

final class ServerActionHandler
extends ActionHandler<ServerActionHandlerType, ServerActionHandler> {
    private final MultiversePortals plugin;
    private final String serverName;

    ServerActionHandler(ServerActionHandlerType handlerType, MultiversePortals plugin, String serverName) {
        super(handlerType);
        this.plugin = plugin;
        this.serverName = serverName;
    }

    @Override
    @NotNull
    public Attempt<Void, ActionFailureReason> runAction(@NotNull MVPortal portal, @NotNull Entity entity) {
        if (!(entity instanceof Player)) {
            return Attempt.failure((FailureReason)ActionFailureReason.INSTANCE, (Message)Message.of((String)"Only players can teleport between servers!", (MessageReplacement[])new MessageReplacement[0]));
        }
        Player player = (Player)entity;
        return (Attempt)Try.run(() -> {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF("Connect");
            out.writeUTF(this.serverName);
            player.sendPluginMessage((Plugin)this.plugin, "BungeeCord", out.toByteArray());
        }).map(Attempt::success).recover(ex -> Attempt.failure((FailureReason)ActionFailureReason.INSTANCE, (Message)Message.of((String)("An error occurred while sending plugin message to proxy: " + ex.getLocalizedMessage()), (MessageReplacement[])new MessageReplacement[0]))).getOrElse(() -> Attempt.failure((FailureReason)ActionFailureReason.INSTANCE, (Message)Message.of((String)"An unknown error occurred while sending plugin message to proxy.", (MessageReplacement[])new MessageReplacement[0])));
    }

    @Override
    public Message actionDescription(Entity entity) {
        return Message.of((String)(String.valueOf(ChatColor.AQUA) + "Transfer to " + String.valueOf(ChatColor.GOLD) + this.serverName + String.valueOf(ChatColor.AQUA) + " server"), (MessageReplacement[])new MessageReplacement[0]);
    }

    @Override
    @NotNull
    public String serialise() {
        return this.serverName;
    }
}

