/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.action.types;

import java.util.Collection;
import org.bukkit.command.CommandSender;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.DestinationsProvider;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.teleportation.AsyncSafetyTeleporter;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.action.ActionFailureReason;
import org.mvplugins.multiverse.portals.action.ActionHandlerType;
import org.mvplugins.multiverse.portals.action.types.MultiverseDestinationActionHandler;

@Service
final class MultiverseDestinationActionHandlerType
extends ActionHandlerType<MultiverseDestinationActionHandlerType, MultiverseDestinationActionHandler> {
    private final DestinationsProvider destinationsProvider;
    private final AsyncSafetyTeleporter teleporter;

    @Inject
    MultiverseDestinationActionHandlerType(@NotNull DestinationsProvider destinationsProvider, @NotNull AsyncSafetyTeleporter teleporter) {
        super("multiverse-destination");
        this.destinationsProvider = destinationsProvider;
        this.teleporter = teleporter;
    }

    @Override
    @NotNull
    public Attempt<MultiverseDestinationActionHandler, ActionFailureReason> parseHandler(@NotNull CommandSender sender, @NotNull String action) {
        if (action.isEmpty()) {
            return Attempt.failure((FailureReason)ActionFailureReason.INSTANCE, (Message)Message.of((String)"Please specific a multiverse destination as the portal's action.", (MessageReplacement[])new MessageReplacement[0]));
        }
        return this.destinationsProvider.parseDestination(sender, action).transform((FailureReason)ActionFailureReason.INSTANCE).map(destinationInstance -> new MultiverseDestinationActionHandler(this, this.teleporter, (DestinationInstance<?, ?>)destinationInstance));
    }

    @Override
    @NotNull
    public Collection<String> suggestActions(@NotNull CommandSender sender, @NotNull String input) {
        return this.destinationsProvider.suggestDestinationStrings(sender, input);
    }
}

